'use client';

import Image from 'next/image';

interface EmptyStateProps {
  title: string;
  description?: string;
  image?: string;
  actionButton?: {
    text: string;
    href?: string;
    onClick?: () => void;
  };
  className?: string;
}

export default function EmptyState({ 
  title, 
  description, 
  image = '/assets/image/empty-state.svg',
  actionButton,
  className = '' 
}: EmptyStateProps) {
  return (
    <div className={`empty-state text-center py-8 ${className}`}>
      <div className="empty-state-image mb-4">
        <Image
          src={image}
          alt="Empty state"
          width={120}
          height={120}
          className="mx-auto opacity-50"
        />
      </div>
      
      <h3 className="empty-state-title text-lg font-semibold text-gray-700 mb-2">
        {title}
      </h3>
      
      {description && (
        <p className="empty-state-description text-gray-500 mb-4 max-w-sm mx-auto">
          {description}
        </p>
      )}
      
      {actionButton && (
        <div className="empty-state-action">
          {actionButton.href ? (
            <a 
              href={actionButton.href}
              className="btn btn-primary px-6 py-2 rounded-lg bg-blue-600 text-white hover:bg-blue-700 transition-colors"
            >
              {actionButton.text}
            </a>
          ) : (
            <button 
              onClick={actionButton.onClick}
              className="btn btn-primary px-6 py-2 rounded-lg bg-blue-600 text-white hover:bg-blue-700 transition-colors"
            >
              {actionButton.text}
            </button>
          )}
        </div>
      )}
    </div>
  );
}