"use client"
import { useTranslations } from "next-intl";
import { getTranslations } from "next-intl/server";
import Image from "next/image";

export default function BenefitsSection() {
  const t = useTranslations();
  return (
    <section className="benefits-wrapper pt-120">
      <div className="container">
        <div className="row">
          <div className="col-12 col-md-6">
            <div className="head-content">
              <div className="heading-box">
                <h2 className="mb-0">
                  {t("home.benefits.title")}{" "}
                  <span className="primary-text">{t("home.name")}</span>
                </h2>
              </div>
            </div>
            <div className="benift-list">
              <ul>
                <li>
                  <div className="list-item">
                    <div className="icon-box">
                      <img
                        src="/assets/image/beniftlist01.svg"
                        alt="benefit 1"
                      />
                    </div>
                    <div className="content">
                      <h5>{t("home.benefits.first.title")}</h5>
                      <p>{t("home.benefits.first.description")}</p>
                    </div>
                  </div>
                </li>
                <li>
                  <div className="list-item">
                    <div className="icon-box">
                      <img
                        src="/assets/image/beniftlist02.svg"
                        alt="benefit 2"
                      />
                    </div>
                    <div className="content">
                      <h5>{t("home.benefits.second.title")}</h5>
                      <p>{t("home.benefits.second.description")}</p>
                    </div>
                  </div>
                </li>
                <li>
                  <div className="list-item">
                    <div className="icon-box">
                      <img
                        src="/assets/image/beniftlist03.svg"
                        alt="benefit 3"
                      />
                    </div>
                    <div className="content">
                      <h5>{t("home.benefits.third.title")}</h5>
                      <p>{t("home.benefits.third.description")}</p>
                    </div>
                  </div>
                </li>
              </ul>
            </div>
          </div>
          <div className="col-12 col-md-6">
            <div className="benift-img-wrapper">
              <img
                src="/assets/image/beniftimg01.png"
                className="img-fluid"
                alt="benefits"
              />
            </div>
          </div>
          <div className="col-12">
            <p className="text-center mt-4 mt-xl-5">
              {t("home.benefits.description")}
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
