'use client';

import { useWebSocketContext } from '@/context/WebSocketContext';

interface MessageConnectionStatusProps {
  className?: string;
}

export default function MessageConnectionStatus({ className = '' }: MessageConnectionStatusProps) {
  const { isConnected, isConnecting, connectionId } = useWebSocketContext();

  return (
    <div className={`connection-status ${className}`}>
      <div className={`status-indicator ${isConnected ? 'connected' : isConnecting ? 'connecting' : 'disconnected'}`}>
        <span className="status-dot"></span>
        <span className="status-text">
          {isConnected ? 'Real-time messaging active' : isConnecting ? 'Connecting...' : 'Offline'}
        </span>
      </div>
      

    </div>
  );
}