import type { Metadata } from 'next';
import './globals.css';
import Script from 'next/script';
import Providers from '@/components/Providers';
import { headers } from 'next/headers';

export const metadata: Metadata = {
  title: 'Smile24 - Freelancer Portal',
  description: 'Connect with freelancers and clients across Europe',
  manifest: "/manifest.webmanifest",

  icons: {
    icon: '/assets/image/favicon.svg',
    shortcut: '/assets/image/favicon.svg',
    apple: '/assets/image/favicon.svg',
  },
};


export default async function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  const headersList = await headers();
  const locale = headersList.get('x-next-intl-locale') || 'en';
  return (
    <html lang={locale}>
      <head>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"></meta>
        {/* Bootstrap CSS */}
        <link
          href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
          rel="stylesheet"
          integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH"
          crossOrigin="anonymous"
        />
        {/* Swiper CSS */}
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.css" />

        {/* Custom CSS */}
        <link rel="stylesheet" href="/assets/css/style.css" />
        <link rel="stylesheet" href="/assets/css/responsive.css" />

        {/* Async load responsive CSS */}
        <link 
          rel="preload" 
          href="/assets/css/responsive.css" 
          as="style"
        />
        <noscript>
          <link rel="stylesheet" href="/assets/css/responsive.css" />
        </noscript>
      </head>
      <body>
        <Providers>
          {children}
        </Providers>
        {/* Bootstrap JS */}
        <Script
          src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
          integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz"
          crossOrigin="anonymous"
          strategy="afterInteractive"
        />
        {/* Swiper JS */}
        <Script
          src="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.js"
          strategy="afterInteractive"
        />
      </body>
    </html>
  );
}
