import { NextRequest, NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

export async function GET(request: NextRequest) {
  try {
    const countries = await prisma.country.findMany({
      where: { isActive: true },
      select: {
        id: true,
        name: true,
        code: true,
      },
      orderBy: { name: 'asc' },
    });

    return NextResponse.json({ countries });
  } catch (error) {
    console.error('Error fetching countries:', error);
    
    // Return fallback countries data
    const fallbackCountries = [
      { id: 'switzerland', name: 'Switzerland', code: 'CH' },
      { id: 'luxembourg', name: 'Luxembourg', code: 'LU' },
      { id: 'belgium', name: 'Belgium', code: 'BE' },
      { id: 'france', name: 'France', code: 'FR' },
      { id: 'italy', name: 'Italy', code: 'IT' },
      { id: 'uk', name: 'United Kingdom', code: 'GB' },
      { id: 'portugal', name: 'Portugal', code: 'PT' },
      { id: 'spain', name: 'Spain', code: 'ES' },
      { id: 'germany', name: 'Germany', code: 'DE' },
      { id: 'austria', name: 'Austria', code: 'AT' }
    ];
    
    return NextResponse.json({ 
      countries: fallbackCountries,
      note: 'Using fallback data - database not available'
    });
  }
}