# Smile24 Setup Guide

## Quick Setup

### 1. Environment Variables
Create a `.env.local` file in the root directory:

```env
# Database Configuration
DATABASE_URL="mysql://username:password@localhost:3306/smile24"

# NextAuth Configuration
NEXTAUTH_URL="http://localhost:3000"
NEXTAUTH_SECRET="your-secret-key-here"

# Optional: OAuth Providers
GOOGLE_CLIENT_ID="your-google-client-id"
GOOGLE_CLIENT_SECRET="your-google-client-secret"

FACEBOOK_CLIENT_ID="your-facebook-client-id"
FACEBOOK_CLIENT_SECRET="your-facebook-client-secret"
```

### 2. Database Setup
```bash
# Install dependencies
npm install

# Generate Prisma client
npx prisma generate

# Push schema to database
npx prisma db push

# Seed the database with initial data
npm run db:seed
```

### 3. Start Development Server
```bash
npm run dev
```

## Database Requirements

- **MySQL 8.0+** or **MariaDB 10.5+**
- Create a database named `smile24`
- Ensure the user has full privileges on the database

## Troubleshooting

### 500 Error on Signup
If you get a 500 error when trying to sign up:

1. **Check database connection**:
   ```bash
   # Test database connection
   curl http://localhost:3000/api/test-db
   ```

2. **Ensure database is seeded**:
   ```bash
   npm run db:seed
   ```

3. **Check environment variables**:
   - Make sure `DATABASE_URL` is correct
   - Verify `NEXTAUTH_SECRET` is set

### Common Issues

1. **"No countries found" error**: Run `npm run db:seed` to populate the database
2. **Database connection failed**: Check your MySQL server and connection string
3. **Prisma errors**: Run `npx prisma generate` and `npx prisma db push`

## Sample Data

After seeding, you'll have:

- **10 countries** with different configurations
- **8 service categories** (Web Development, Design, etc.)
- **3 sample users**:
  - Admin: `admin@smile24.com` / `admin@123`
  - Client: `client@example.com` / `admin@123`
  - Freelancer: `freelancer@example.com` / `admin@123`

## Development Commands

```bash
npm run dev          # Start development server
npm run build        # Build for production
npm run start        # Start production server
npm run db:push      # Push schema changes
npm run db:seed      # Seed database
npm run db:studio    # Open Prisma Studio
```

## Next Steps
1. **Test the application**: Visit `http://localhost:3000`
2. **Try signing up**: Use the sample credentials or create new accounts
3. **Explore features**: Navigate through different user roles and pages
4. **Customize**: Modify the code to fit your specific requirements 
