import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function seedCountries() {
  try {
    console.log('Starting to seed countries...');

    const countries = [
      {
        id: 'switzerland',
        name: 'Switzerland',
        code: 'CH',
        domain: 'smile24.ch',
        languages: 'de,fr,it,en',
        defaultLanguage: 'de',
        currency: 'CHF',
        currencySymbol: 'CHF',
        packagePrice: 19.90,
        paymentGateways: 'stripe,twint',
        isActive: true
      },
      {
        id: 'luxembourg',
        name: 'Luxembourg',
        code: 'LU',
        domain: 'smile24.lu',
        languages: 'fr,de,en',
        defaultLanguage: 'fr',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'belgium',
        name: 'Belgium',
        code: 'BE',
        domain: 'smile24.be',
        languages: 'fr,nl,de,en',
        defaultLanguage: 'fr',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'france',
        name: 'France',
        code: 'FR',
        domain: 'smile24.fr',
        languages: 'fr,en',
        defaultLanguage: 'fr',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'italy',
        name: 'Italy',
        code: 'IT',
        domain: 'smile24.it',
        languages: 'it,en',
        defaultLanguage: 'it',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'uk',
        name: 'United Kingdom',
        code: 'GB',
        domain: 'smile24.co.uk',
        languages: 'en',
        defaultLanguage: 'en',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'portugal',
        name: 'Portugal',
        code: 'PT',
        domain: 'smile24.pt',
        languages: 'pt,en',
        defaultLanguage: 'pt',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'spain',
        name: 'Spain',
        code: 'ES',
        domain: 'smile24.es',
        languages: 'es,en',
        defaultLanguage: 'es',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'germany',
        name: 'Germany',
        code: 'DE',
        domain: 'smile24.de',
        languages: 'de,en',
        defaultLanguage: 'de',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      },
      {
        id: 'austria',
        name: 'Austria',
        code: 'AT',
        domain: 'smile24.at',
        languages: 'de,en',
        defaultLanguage: 'de',
        currency: 'EUR',
        currencySymbol: '€',
        packagePrice: 9.90,
        paymentGateways: 'stripe',
        isActive: true
      }
    ];

    // Insert countries using upsert to avoid duplicates
    for (const countryData of countries) {
      await prisma.country.upsert({
        where: { id: countryData.id },
        update: countryData,
        create: countryData
      });
    }

    console.log('✅ Countries seeded successfully!');
    console.log(`Created/updated ${countries.length} countries`);

  } catch (error) {
    console.error('Error seeding countries:', error);
  } finally {
    await prisma.$disconnect();
  }
}

// Run if called directly
if (require.main === module) {
  seedCountries()
    .catch((e) => {
      console.error(e);
      process.exit(1);
    });
}

export { seedCountries };