'use client';

import { useState, useEffect } from 'react';
import { useSession } from 'next-auth/react';

export async function chatConversation(projectId:any, buyerId:any, sellerId:any, lastMessage:any ): Promise<any> {
    try {
      const response = await fetch('/api/chat_conversation', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({
          projectId: projectId,
          buyerId: buyerId,
          sellerId: sellerId,
          lastMessage: lastMessage,
        }),
      });

      if (!response.ok) {
        const errorData = await response.json();
        throw new Error(errorData.message || 'Something went wrong');
      }
    } catch (err: unknown) {
      const message = err instanceof Error ? err.message : 'Something went wrong';
         throw new Error(message || 'Something went wrong');
    } 
}








