"use client";

import { useEffect, useState } from "react";

const ScrollToTop = () => {
  const [isVisible, setIsVisible] = useState(false);

  useEffect(() => {
    const toggleVisibility = () => {
      if (window.scrollY > 300) {
        setIsVisible(true);
      } else {
        setIsVisible(false);
      }
    };

    window.addEventListener("scroll", toggleVisibility);
    return () => window.removeEventListener("scroll", toggleVisibility);
  }, []);

  const scrollToTop = () => {
    window.scrollTo({
      top: 0,
      behavior: "smooth",
    });
  };

  return (
    <>
      {isVisible && (
        <button
          onClick={scrollToTop}
          className="scroll-to-top transition"
          aria-label="Scroll to top"
        >
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M18.8211 9.56988C18.8211 9.75988 18.7511 9.94988 18.6011 10.0999C18.3111 10.3899 17.8311 10.3899 17.5411 10.0999L12.0011 4.55988L6.46109 10.0999C6.17109 10.3899 5.69109 10.3899 5.40109 10.0999C5.11109 9.80988 5.11109 9.32988 5.40109 9.03988L11.4711 2.96988C11.7611 2.67988 12.2411 2.67988 12.5311 2.96988L18.6011 9.03988C18.7511 9.18988 18.8211 9.37988 18.8211 9.56988Z" fill="#ffffff"/>
                <path d="M12.75 3.67V20.5C12.75 20.91 12.41 21.25 12 21.25C11.59 21.25 11.25 20.91 11.25 20.5V3.67C11.25 3.26 11.59 2.92 12 2.92C12.41 2.92 12.75 3.26 12.75 3.67Z" fill="#ffffff"/>
            </svg>
        </button>
      )}
    </>
  );
};

export default ScrollToTop;
