"use client";

import { useEffect } from "react";
import { getCountryById } from "@/lib/countries";
import { useSession, signOut} from "next-auth/react";
import { usePathname } from "next/navigation";

export default function CountryDomainRedirect() {
  const { data: session, status } = useSession();
  const pathname = usePathname();

  useEffect(() => {
    const handleRedirect = async () => {
        if (status !== "authenticated" || !session?.user?.countryId) return;
        const countryId = session?.user?.countryId;
        const userCountry = getCountryById(countryId);
        if (!userCountry) return;
        var domainName = window?.location?.hostname ?? '';
          

            // only HIPL servers
              if(domainName == "smile24.hipl-staging2.com"){
                  domainName = "smile24.ch";
              }
              if(domainName == "smile24-france.hipl-staging2.com"){
                domainName = "smile24.fr";
              }
              if(domainName == "smile24-uk.hipl-staging2.com"){
                domainName ="smile24.uk"
              }
            // only HIPL servers

          if(domainName !=  userCountry?.domain){
              //window.location.replace(`https://${userCountry?.domain}/${userCountry?.languages[0]}`);
              if(domainName != "localhost"){
                  await signOut({ redirect: false }); 
              }

              if(domainName == "localhost"){

              }else if(userCountry?.domain == 'smile24.ch'){
                  window.location.replace(`https://smile24.hipl-staging2.com/${userCountry?.languages[0]}`);
              }else if(userCountry?.domain == 'smile24.ch'){
                  window.location.replace(`https://smile24.hipl-staging2.com/${userCountry?.languages[0]}`);
              }else if(userCountry?.domain == 'smile24.fr'){
                  window.location.replace(`https://smile24-france.hipl-staging2.com/${userCountry?.languages[0]}`);
              }else if(userCountry?.domain == 'smile24.uk'){
                  window.location.replace(`https://smile24-uk.hipl-staging2.com/${userCountry?.languages[0]}`);
              }
          }
      };

       handleRedirect();


    //let currentDomain = window.location.hostname.toLowerCase();
    // Map staging/dev domains to production domains
    // switch (currentDomain) {
    //   case "localhost":
    //   case "smile24.hipl-staging2.com":
    //     currentDomain = "smile24.ch";
    //     break;
    //   case "smile24-france.hipl-staging2.com":
    //     currentDomain = "smile24.fr";
    //     break;
    //   case "smile24-uk.hipl-staging2.com":
    //     currentDomain = "smile24.uk";
    //     break;
    //   case "smile24-belgium.hipl-staging2.com":
    //     currentDomain = "smile24.be";
    //     break;
    //   case "smile24-luxembourg.hipl-staging2.com":
    //     currentDomain = "smile24.lu";
    //     break;
    //   case "smile24-italy.hipl-staging2.com":
    //     currentDomain = "smile24.it";
    //     break;
    //   case "smile24-portugal.hipl-staging2.com":
    //     currentDomain = "smile24.pt";
    //     break;
    //   case "smile24-spain.hipl-staging2.com":
    //     currentDomain = "smile24.es";
    //     break;
    //   case "smile77.de":
    //     currentDomain = "smile77.de";
    //     break;
    //   case "smile77.at":
    //     currentDomain = "smile77.at";
    //     break;
    //   default:
    //     break;
    // }

    // const normalizeDomain = (domain: string) =>
    //   domain.replace(/^www\./, "").toLowerCase();

    // if (
    //   normalizeDomain(currentDomain) !== normalizeDomain(userCountry.domain)
    // ) {
    //   window.location.replace(
    //     `${window.location.protocol}//${userCountry.domain}${window.location.pathname}${window.location.search}`
    //   );
    // }
  }, [status, session, pathname]);
  return null;
}





 
 