"use client";

import { useEffect, useRef  } from "react";
import { getCountryById } from "@/lib/countries";
import { useSession, signOut} from "next-auth/react";
import { usePathname } from "next/navigation";

export default function CountryDomainRedirect() {
  const { data: session, status } = useSession();
  const pathname = usePathname();
  const redirected = useRef(false);

  useEffect(() => {
    const handleRedirect = async () => {
        if (redirected.current) return;
        if (status !== "authenticated" || !session?.user?.countryId) return;
        const countryId = session?.user?.countryId;
        const userCountry = getCountryById(countryId);
        if (!userCountry) return;
        var domainName = window?.location?.hostname ?? '';
            // only HIPL servers
              if(domainName == "smile24.hipl-staging2.com"){
                  domainName = "smile24.ch";
              }else if(domainName == "smile24-france.hipl-staging2.com"){
                domainName = "smile24.fr";
              }else if(domainName == "smile24-uk.hipl-staging2.com"){
                domainName ="smile24.uk"
              }
            // only HIPL servers
          if(domainName !=  userCountry?.domain){
              redirected.current = true;
              //window.location.replace(`https://${userCountry?.domain}/${userCountry?.languages[0]}`);
              if(domainName != "localhost"){
                  await signOut({ redirect: false }); 
              }

              if(domainName == "localhost"){

              }else if(userCountry?.domain == 'smile24.ch'){
                  window.location.replace(`https://smile24.hipl-staging2.com/${userCountry?.languages[0]}`);
              }else if(userCountry?.domain == 'smile24.fr'){
                window.location.replace(`https://smile24-france.hipl-staging2.com/${userCountry?.languages[0]}`);
              }else if(userCountry?.domain == 'smile24.uk'){
                 window.location.replace(`https://smile24-uk.hipl-staging2.com/${userCountry?.languages[0]}`);
              }
          }
      };
       handleRedirect();   
  }, [status, session, pathname]);
  return null;
}





 
 