'use client';

import { useEffect } from 'react';
import ErrorState from '@/components/ui/ErrorState';

export default function Error({
  error,
  reset,
}: {
  error: Error & { digest?: string };
  reset: () => void;
}) {
  useEffect(() => {
    console.error('Application error:', error);
  }, [error]);

  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-50">
      <div className="max-w-md w-full">
        <ErrorState 
          title="Something went wrong"
          description="An unexpected error occurred. Please try again or contact support if the problem persists."
          errorCode={error.digest}
          onRetry={reset}
        />
      </div>
    </div>
  );
}