const mysql = require('mysql2/promise');

async function fixReviewTable() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'smile24',
      port: 3306
    });

    console.log('🔧 Fixing Review table schema...');

    // Add the missing recipientId column
    await connection.execute(`
      ALTER TABLE Review 
      ADD COLUMN IF NOT EXISTS recipientId VARCHAR(191) NOT NULL AFTER revieweeId,
      ADD FOREIGN KEY IF NOT EXISTS (recipientId) REFERENCES User(id) ON DELETE CASCADE
    `);

    console.log('✅ Added recipientId column to Review table');

    // Update existing reviews to have recipientId same as revieweeId for now
    await connection.execute(`
      UPDATE Review SET recipientId = revieweeId WHERE recipientId IS NULL OR recipientId = ''
    `);

    console.log('✅ Updated existing reviews with recipientId');
    
  } catch (error) {
    console.error('❌ Error fixing Review table:', error.message);
  } finally {
    if (connection) {
      await connection.end();
    }
  }
}

fixReviewTable();
