"use client";

import { useState, useEffect } from "react";
// import ConversationList from './ConversationList';
import ConversationListNew from "./ConversationListNew";
// import MessageThread from './MessageThread';
// import MessageThreadNew from "./MessageThreadNew";
import MessageConnectionStatus from "./MessageConnectionStatus";
import "./messages.css";
import MessageThread from "./MessageThread";
import { Project } from "@prisma/client";

interface Profile {
  firstName?: string;
  lastName?: string;
  profileImage?: string;
}

interface User {
  id: string;
  email: string;
  profile?: Profile;
}

interface MessagesInterfaceProps {
  projectId?: string;
  preselectedContactId?: string;
  projectStatus?: string;
}

export default function MessagesInterface({
  projectId,
  preselectedContactId,
  projectStatus,
}: MessagesInterfaceProps) {
  const [selectedContact, setSelectedContact] = useState<User | null>(null);
  const [selectedContactId, setSelectedContactId] = useState<
    string | undefined
  >(preselectedContactId);
  const [shouldSelectFirst, setShouldSelectFirst] = useState<boolean>(
    !preselectedContactId
  );
  const [chatData, setChatData] = useState<any>();
  const [selectedProjectId, setSelectedProjectId] = useState<string>("");
  const [selectedProjectStatus, setSelectedProjectStatus] =
    useState<string>("");

  // When preselectedContactId changes, fetch the contact details
  useEffect(() => {
    if (preselectedContactId && preselectedContactId !== selectedContactId) {
      setSelectedContactId(preselectedContactId);
      fetchContactDetails(preselectedContactId);
      setShouldSelectFirst(false);
    }
  }, [preselectedContactId]);

  const fetchContactDetails = async (contactId: string) => {
    try {
      const response = await fetch(`/api/messages/conversations/${contactId}`);
      if (response.ok) {
        const data = await response.json();
        if (data.data && data.data.contact) {
          setSelectedContact(data.data.contact);
        }
      }
    } catch (error) {}
  };

  const handleSelectConversation = (
    contactId: string,
    contact: User,
    project: any
  ) => {

    console.log(contactId);
    setSelectedContactId(contactId);

    console.log("Project: ", project);

    if (project) {
      setSelectedProjectId(project.id);
      setSelectedProjectStatus(project.status);
    }
    setSelectedContact(contact);
    setShouldSelectFirst(false);
  };
  // const handleSelectConversation = (contactId: string) => {
  //     setSelectedContactId(contactId);
  // };

  const handleFirstConversationAvailable = (
    contactId: string,
    contact: User
  ) => {
    if (shouldSelectFirst && !selectedContactId) {
      setSelectedContactId(contactId);
      setSelectedContact(contact);
      setShouldSelectFirst(false);
    }
  };

  // useEffect(() => {
  //   const fetchConversationThread = async () => {
  //     const params = new URLSearchParams({});
  //     params.set("id", selectedContactId ?? "");
  //     try {
  //       // setLoading(true);
  //       const response = await fetch(
  //         `/api/chat_conversation_thread?${params.toString()}`
  //       );
  //       if (response.ok) {
  //         const data = await response.json();
  //         setChatData(data.conversationData);
  //       }
  //     } catch (error) {
  //     } finally {
  //       // setLoading(false);
  //     }
  //   };

  //   fetchConversationThread();
  // }, [selectedContactId]);

  return (
    <div className="chat-frame-wrap" id="frame">
      {/* <ConversationList 
        onSelectConversation={handleSelectConversation}
        selectedContactId={selectedContactId}
        onFirstConversationAvailable={handleFirstConversationAvailable}
        shouldSelectFirst={shouldSelectFirst}
      /> */}
      <ConversationListNew
        onSelectConversation={handleSelectConversation}
        selectedContactId={selectedContactId}
        onFirstConversationAvailable={handleFirstConversationAvailable}
        shouldSelectFirst={shouldSelectFirst}
      />

      {selectedContactId ? (
        <MessageThread
          conversationId={selectedContactId}
          contact={selectedContact}
          projectId={selectedProjectId}
          projectStatus={selectedProjectStatus}
        />
      ) : (
        // <MessageThreadNew selectedContactId={selectedContactId} chatData={chatData}/>

        <div className="content">
          <div className="d-flex align-items-center justify-content-center h-100 text-muted">
            <div className="text-center">
              <img
                src="/assets/image/message-chat.svg"
                alt=""
                width="80"
                height="80"
                className="mb-3 opacity-50"
              />
              <h5>Select a conversation</h5>
              <p>Choose a conversation from the left to start messaging</p>
              {/* <MessageConnectionStatus className="mt-3" /> */}
            </div>
          </div>
        </div>
      )}
    </div>
  );
}
