<?php $__env->startSection('title'); ?><?php echo app('translator')->get('quickadmin.area_master.title'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('customCss'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<link rel="stylesheet" href="<?php echo e(asset('admintheme/assets/css/printView-datatable.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>
<div class="card MainBox">
  <div class="mainHeading">
    <h4><?php echo app('translator')->get('quickadmin.area_master.title'); ?></h4>
    <div class="">
      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('area_create')): ?>
      <button type="button" class="btn addRecordBtn addBtn add_area" title="New Area"><i class="fas fa-plus"></i><?php echo app('translator')->get('quickadmin.area_master.fields.new_area'); ?></button>
      <?php endif; ?>
    </div>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive fixed_Search area-table">
      <?php echo e($dataTable->table(['class' => 'table dt-responsive', 'style' => 'width:100%;'])); ?>

    </div>
  </div>
</div>

<!-- Add Edit Modal -->
<div class="modal fade p-2" id="areaModal" tabindex="-1" role="dialog" aria-labelledby="areaModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle"><span class="Add_edit_area">Add</span> <?php echo app('translator')->get('quickadmin.area_master.fields.area'); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="area_form">
        <div class="modal-body floatingLabel">
          <div class="form-group">
            <label for="naem"><?php echo app('translator')->get('quickadmin.area_master.fields.name'); ?><span class="text-danger">*</span></label>
            <input type="hidden" class="area_edit_id">
            <input type="text" class="form-control area_edit_address" id="address" placeholder="Enter Name" name="name">
            <span class="error_address text-danger error"></span>
          </div>
        </div>
        <div class="modal-footer pt-0">
          <div class="success_error_message"></div>
          <button type="submit" class="btn btn-primary save_btn m-0" title="Save"><?php echo app('translator')->get('quickadmin.area_master.fields.save'); ?></button>
        </div>
      </form>
    </div>
  </div>
</div>
<!-- Add Edit Modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('customJS'); ?>
<?php echo $dataTable->scripts(); ?>

<script src="<?php echo e(asset('admintheme/assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>">
</script>
<script src="<?php echo e(asset('admintheme/assets/js/page/datatables.js')); ?>"></script>

<script type="text/javascript">
  // add or edit
  $(document).ready(function() {
    var DataaTable = $('#area-table').DataTable();
    $(document).on('click', '.add_area', function() {
      $('.error').html('');
      $("#areaModal").modal('show');
      $(".area_edit_id").val('');
      $(".area_edit_address").val('');
      $(".save_btn").html('Save');
      $(".Add_edit_area").html('New');
    })
    $(document).on('click', '.edit_area', function() {
      $('.error').html('');
      $("#areaModal").modal('show');
      $(".area_edit_id").val($(this).data('id'));
      $(".area_edit_address").val($(this).data('address'));
      $(".save_btn").html('Update');
      $(".Add_edit_area").html('Edit');
    })


    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $(document).on('keyup', function(e) {
      if (e.key === 'Enter') {
        $('#area_form').submit();
      }
    });
    $(document).on('submit', "#area_form", function(e) {
      e.preventDefault();
      var address = $("#address").val();
      var _id = $(".area_edit_id").val();
      $('.save_btn').prop('disabled', true);
      var postType = "POST";
      var post_url = "<?php echo e(route('areas.store')); ?>"
      if (_id) {
        //  var post_url = "/admin/master/areas/" + _id;
        var post_url = "<?php echo e(route('areas.update',['area'=> ':areaId'])); ?>";
        post_url = post_url.replace(':areaId', _id);
        var postType = "PUT";
      }
      $.ajax({
        type: postType,
        url: post_url,
        data: {
          address: address,
          id: _id,
        },
        success: function(data) {
          $('.save_btn').prop('disabled', false);
          if ($.isEmptyObject(data.error)) {
            $("#areaModal").modal('hide');
            DataaTable.ajax.reload();
            var alertType = "<?php echo e(trans('quickadmin.alert-type.success')); ?>";
            var message = data.success;
            var title = "Area";
            showToaster(title, alertType, message);
          } else {
            printErrorMsg(data.error);
          }
        }
      });
    });

    function printErrorMsg(msg) {
      $.each(msg, function(key, value) {
        $(`.error_${key}`).html(value);
      });
    }
    // add or edit
    // delete
    $(document).on('click', '.delete_area', function() {
      var delete_id = $(this).data('id');
      var delete_url = "<?php echo e(route('areas.destroy',['area'=> ':areaId'])); ?>";
      delete_url = delete_url.replace(':areaId', delete_id);
      swal({
        title: "Are  you sure?",
        text: "<?php echo e(trans('messages.areYouSure')); ?>",
        icon: 'warning',
        buttons: {
          confirm: 'Yes, delete',
          cancel: 'No, cancel',
        },
        dangerMode: true,
      }).then(function(willDelete) {
        if (willDelete) {
          $.ajax({
            type: "DELETE",
            url: delete_url,
            success: function(data) {
              if ($.isEmptyObject(data.error)) {
                DataaTable.ajax.reload();
                var alertType = "<?php echo e(trans('quickadmin.alert-type.success')); ?>";
                var message = "<?php echo e(trans('messages.crud.delete_record')); ?>";
                var title = "Area";
                showToaster(title, alertType, message);
              }
            },
            error: function(xhr) {
              swal("<?php echo e(trans('quickadmin.order.invoice')); ?>", 'Something Went Wrong!', 'error');
            }
          });
        }
      })
    });
    // delete
  })
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/area/index.blade.php ENDPATH**/ ?>