<?php $__env->startSection('title'); ?><?php echo app('translator')->get('quickadmin.brand_master.title'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('customCss'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" >
<link rel="stylesheet" href="<?php echo e(asset('admintheme/assets/css/printView-datatable.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>

<div class="card MainBox">
  <div class="mainHeading">
    <h4><?php echo app('translator')->get('quickadmin.brand_master.title'); ?></h4>
    <div>
      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand_create')): ?>
      <button type="button" class="btn addRecordBtn addBtn add_brand" title="<?php echo app('translator')->get('quickadmin.brand_master.fields.new_brand'); ?>" ><i class="fas fa-plus"></i><?php echo app('translator')->get('quickadmin.brand_master.fields.new_brand'); ?></button>
      <?php endif; ?> 
    </div>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive fixed_Search brand-table">
      <?php echo e($dataTable->table(['class' => 'table dt-responsive', 'style' => 'width:100%;'])); ?>

    </div>
  </div>
</div>
<?php echo $__env->make('admin.brand.add-brand', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('customJS'); ?>
<?php echo $dataTable->scripts(); ?>

<script src="<?php echo e(asset('admintheme/assets/bundles/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('admintheme/assets/js/page/datatables.js')); ?>"></script>
<script type="text/javascript">
    // add or edit
    $(document).ready(function(){
        var DataaTable = $('#brand-table').DataTable();
        $(document).on('click','.edit_brand',function(){
            $('.error').html('');
            $("#brandModal").modal('show');
            $(".brand_edit_id").val($(this).data('id'));
            $(".brand_edit_name").val($(this).data('name'));
            $(".save_btn").html('Update');
            $(".Add_edit_brand").html('Edit');
        })
    
        $.ajaxSetup({
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        // add or edit
        // delete
        $(document).on('click','.delete_brand',function(){
            var delete_id = $(this).data('id');
            var delete_url = "<?php echo e(route('brand.destroy',['brand'=> ':brandId'])); ?>";
            delete_url = delete_url.replace(':brandId', delete_id);
            swal({
                title: "Are  you sure?",
                text: "<?php echo e(trans('messages.areYouSure')); ?>",
                icon: 'warning',
                buttons: {
                    confirm: 'Yes, delete',
                    cancel: 'No, cancel',
                },
                dangerMode: true,
            }).then(function(willDelete) {
                if(willDelete) {  
                    $.ajax({
                    type: "DELETE",
                    url: delete_url,              
                    success: function(data) {
                        if ($.isEmptyObject(data.error)) {
                        DataaTable.ajax.reload();
                        var alertType = "<?php echo e(trans('quickadmin.alert-type.success')); ?>";
                        var message = "<?php echo e(trans('messages.crud.delete_record')); ?>";
                        var title = "Brand";
                        showToaster(title,alertType,message);                    
                        } 
                    },
                    error: function (xhr) {
                        swal("<?php echo e(trans('quickadmin.order.invoice')); ?>", 'Something Went Wrong!', 'error');
                    }
                    });
                }
            })
        });
        // delete
    })


</script>
<?php echo $__env->make('admin/brand/_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/brand/index.blade.php ENDPATH**/ ?>