<?php if($record_type === \App\Models\PaymentTransaction::class): ?>
<div class="modal fade px-2" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="editModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalCenterTitle"><?php echo app('translator')->get('quickadmin.qa_view'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body floatingLabel">
                <ul class="dataShowing">
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.order.fields.invoice_date'); ?></label>
                        <span class="text-capitalize" field-key='entry_date'><?php echo e($record->entry_date->format('d-m-Y')); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.voucher_number'); ?></label>
                        <span class="text-capitalize" field-key='voucher_number'>#<?php echo e($record->voucher_number ?? ''); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.particulars'); ?></label>
                        <span class="text-capitalize" field-key='remark'><?php echo e($record->remark ?? 'Cash Receipt'); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.payment_type'); ?></label>
                        <span class="text-capitalize" field-key='payment_type'><?php echo e($record->payment_type ? ucfirst($record->payment_type) : ''); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.payment_way'); ?></label>
                        <span class="text-capitalize" field-key='payment_way'><?php echo e(config('constant.paymentModifyWays')[$record->payment_way]); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.qa_created_at'); ?></label>
                        <span class="text-capitalize" field-key='created_at'><?php echo e($record->created_at->format('d-m-Y H:i A')); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?></label>
                        <span class="text-capitalize" field-key='amount'><i class="fa fa-inr" aria-hidden="true"></i> <?php echo e(number_format($record->amount,2)); ?></span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if($record_type === \App\Models\CashManagement::class): ?>
<div class="modal fade px-2" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="editModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalCenterTitle"><?php echo app('translator')->get('quickadmin.qa_view'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body floatingLabel">
                <ul class="dataShowing">
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.cash-management.fields.staff_name'); ?></label>
                        <span class="text-capitalize" field-key='entry_date'><?php echo e($record->user->name??''); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.order.fields.invoice_date'); ?></label>
                        <span class="text-capitalize" field-key='entry_date'><?php echo e($record->entry_date); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.voucher_number'); ?></label>
                        <span class="text-capitalize" field-key='voucher_number'>#<?php echo e($record->voucher_number ?? ''); ?></span>
                    </li>
                    
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.payment_way'); ?></label>
                        <span class="text-capitalize" field-key='payment_way'><?php echo e(config('constant.paymentModifyWays')[$record->payment_way]); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.qa_created_at'); ?></label>
                        <span class="text-capitalize" field-key='created_at'><?php echo e($record->created_at->format('d-m-Y H:i A')); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.amount'); ?></label>
                        <span class="text-capitalize" field-key='amount'><i class="fa fa-inr" aria-hidden="true"></i> <?php echo e(number_format($record->amount,2)); ?></span>
                    </li>

                    <li>
                        <label><?php echo app('translator')->get('quickadmin.transaction.fields.remark'); ?></label>
                        <span class="text-capitalize" field-key='remark'><?php echo e($record->remark ?? ''); ?></span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>







<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/cash_balance/show.blade.php ENDPATH**/ ?>