<script type="text/javascript">
    $(document).ready(function(){
        $(document).on('click','.add_unit',function(){
            $('.error').html('');
            $("#unitModal").modal('show');
            $(".unit_edit_id").val('');
            $(".unit_edit_name").val('');
            $(".save_btn").html('Save');
            $(".Add_edit_unit").html('New');
        });
        $(document).on('keyup', function(e) {
          if (e.key === 'Enter') {
            $('#unit_form').submit();
          }
        });
        $(document).on('submit', "#unit_form", function(e) {
            e.preventDefault();
            var name = $("#unit_form #name").val();
            var _id = $("#unit_form .unit_edit_id").val();
            $('.save_btn').prop('disabled', true);
            var postType = "POST";
            var post_url = "<?php echo e(route('unit-type.store')); ?>"
            if(_id){
                var post_url = "<?php echo e(route('unit-type.update',['unit_type'=> ':unitId'])); ?>";
                post_url = post_url.replace(':unitId', _id);
                var postType = "PUT";
            }
            $.ajax({
                type: postType,
                url: post_url,
                data: {
                    name: name,
                    id: _id,
                },
                success: function(data) {
                $('.save_btn').prop('disabled', false);
                if ($.isEmptyObject(data.error)) {
                    $("#unitModal").modal('hide');
                    if($("#unit_type").length > 0){
                        var unitVal = $("#unit_type").val();
                        $("#unit_type").empty();
                        $("#unit_type").append('<option value="" disabled selected>Select Unit Type</option>');
                        $.each(data.unitList, function (key, value) {
                            var selected = unitVal == value.id ? 'selected' : '';
                            $("#unit_type").append('<option value="' + value.id + '" ' + selected + '>' + value.name + '</option>');
                        });
                    }else{
                        $('#unit-table').DataTable().ajax.reload();
                        var alertType = "<?php echo e(trans('quickadmin.alert-type.success')); ?>";
                        var message = data.success;
                        var title = "Unit";
                        showToaster(title,alertType,message);      
                    }             
                } else {
                    printErrorMsg(data.error);
                }
                }
            });
        });
        function printErrorMsg(msg) {
            $.each(msg, function(key, value) {
                $(`#unit_form .error_${key}`).html(value);
            });
        }        
    });
</script><?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/unit_type/_script.blade.php ENDPATH**/ ?>