<?php $__env->startSection('title', 'Statement of '.$customer->name); ?>
<?php $__env->startSection('styles'); ?>
    <style>
		body{
            text-align:center;
		}

        .table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0;
            padding: 2px;
            padding-left:0;
            color: #000;
            padding-right:5px;
        }

        .table th {
            white-space: nowrap;
            color:#000;
            font-size: 14px;
            font-weight: bold;
        }
        .table th p{
            margin: 0px 0px 5px;
            line-height: 12px;
        }
        .table th .font-18{
            font-size: 18px;
        }

        .font-18{
            font-size: 18px;
        }
        .font-20{
            font-size: 20px;
        }

        .table tfoot tr td {
            color:#000 !important;
            padding: 8px;
        }

        .table td {
            padding: 1px 1px 2px 14px;
            color:#000;
            font-size: 14px;
        }

        .text-center {
            text-align: center;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }
        .font-800{
            font-weight: bold;
        }
        .padding-0{
            padding: 0;
        }

        .header-wrap tr th{
            padding-bottom:0;
        }
        .heading_wrap{
            border: 0.5px solid #333;
            border-left:0;
            border-right:0;
        }

        .heading_wrap thead th{
            padding: 8px;
            border-bottom:1px solid #333;
            text-align:left;
        }

        .heading_wrap tbody td{
            font-size: 14px;
            font-weight:400;
            color:#000000;
            padding: 8px;
            text-align:left;
        }
        .w-50{
            white-space:normal;
            width:100px;
            min-width:50px;
        }
        .footer_tab ,.footer_tab tr, .footer_tab td{
            padding: 0;
            font-size: 14px;
        }
        .footer_tab table{
            padding-top: 0;
            margin-left:auto;
        }
        .footer_tab table tr{
            padding-top:0;
        }
        .footer_tab table td{
            font-weight:bold;
            font-size: 14px;
            padding: 8px;
        }
        .border-top {
            border-top:0.5px solid #000;
        }
        .border-top td, .space-wrap td{
            padding-top:5px;
        }
        .space-wrap td{
            padding-bottom:5px;
        }
        @page {
            margin: 10px 20px;
        }

         .footer_tab table tr td{
            border:1px solid #000;
         }

         .heading_wrap tr td,  .heading_wrap tr th{
            text-align: center;
            border:1px solid #000;
         }
         .main {
            margin-bottom:1rem;
         }
         .main p{
            margin:0;
         }
         .sm-font{
            font-size:14px;
         }
         .my-3{
            margin:2px 0 !important;
         }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
    $debitTotal = 0;
    $creditTotal = 0;
    $openingBalance = $openingBalance ?? 0;
    ?>

    <div class="main">
        <div class="text-center">
                <p class="font-20 font-800"><?php echo e(ucwords($customer->name)); ?></p>
                <p class="sm-font my-3"><?php echo app('translator')->get('quickadmin.customers.fields.area_address'); ?> : <?php echo e($customer->area->address ?? ''); ?></p>
                <p class="sm-font my-3"><?php echo app('translator')->get('quickadmin.customers.fields.statement'); ?></p>
                <?php if(!is_null($from_date) && !is_null($to_date)): ?>
                    <p class="sm-font"><?php echo e(\Carbon\Carbon::parse($from_date)->format('d F Y')); ?> to <?php echo e(\Carbon\Carbon::parse($to_date)->format('d F Y')); ?></p>
                <?php endif; ?>
        </div>
    </div>

    <table class="table heading_wrap" style="border-spacing: 0;">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('quickadmin.customers.fields.invoice_date'); ?></th>
                <th class="w-100"><?php echo app('translator')->get('quickadmin.customers.fields.particulars'); ?></th>
                <th><?php echo app('translator')->get('quickadmin.transaction.fields.voucher_number'); ?></th>
                <th><?php echo app('translator')->get('quickadmin.customers.fields.debit'); ?></th>
                <th><?php echo app('translator')->get('quickadmin.customers.fields.credit'); ?></th>
            </tr>
        </thead>
        <tbody>
                <?php if(count($customer->transaction) > 0): ?>
                    <?php $__currentLoopData = $customer->transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($transaction->remark == 'Opening balance'): ?>
                            
                            <?php continue; ?>
                        <?php endif; ?>

                        <tr>
                            <td>
                                <?php echo e($transaction->entry_date->format('d-m-Y')); ?>

                            </td>

                            <td class="w-100">
                                    <?php echo e($transaction->remark); ?>

                            </td>

                            <td>
                                <?php echo e($transaction->voucher_number); ?>

                            </td>

                            <td>
                                <?php if($transaction->payment_type == 'debit'): ?>
                                <span style="font-family: DejaVu Sans, sans-serif;">&#x20B9;</span> <?php echo e(number_format($transaction->amount,0)); ?>

                                    <?php
                                        $debitTotal += (float)$transaction->amount;
                                    ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($transaction->payment_type == 'credit'): ?>
                                <span style="font-family: DejaVu Sans, sans-serif;">&#x20B9;</span> <?php echo e(number_format($transaction->amount,0)); ?>


                                    <?php
                                        $creditTotal += (float)$transaction->amount;
                                    ?>
                                <?php endif; ?>
                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr>
                    <td colspan="4"><?php echo app('translator')->get('quickadmin.qa_no_entries_in_table'); ?></td>
                </tr>
                <?php endif; ?>

        </tbody>
        <tfoot>
            <tr class="text-right">
                <td colspan="3" class="text-right" style="text-align: right; padding-right: 9px;font-size: 14px;">
                    <strong><?php echo app('translator')->get('quickadmin.customers.fields.opening_blance'); ?></strong>
                </td>
                <td style="font-size: 14px;">
                    <strong> <span style="font-family: DejaVu Sans, sans-serif;">&#x20B9;</span> <?php echo e(isset($openingBalance) ? number_format(abs($openingBalance),0) : '0.00'); ?> </strong>
                </td>
                <td></td>
            </tr>

            <tr class="text-right space-wrap">
                <td colspan="3" class="text-right" style="text-align: right; padding-right: 9px;font-size: 14px;">
                    <strong><?php echo app('translator')->get('quickadmin.customers.fields.current_balance'); ?></strong>
                </td>
                <td style="font-size: 14px;">
                    <?php if(isset($debitTotal) && $debitTotal > 0): ?>
                        <strong><span style="font-family: DejaVu Sans, sans-serif;">&#x20B9;</span> <?php echo e(number_format($debitTotal,0)); ?></strong></td>
                    <?php endif; ?>
                <td style="font-size: 14px;">
                    <?php if(isset($creditTotal) && $creditTotal > 0): ?>
                        <strong><span style="font-family: DejaVu Sans, sans-serif;">&#x20B9;</span> <?php echo e(number_format($creditTotal,0)); ?></strong></td>
                    <?php endif; ?>
            </tr>

            <?php
                $closingBalance = $debitTotal - $creditTotal;
                $closingBalance = $closingBalance + $openingBalance;
            ?>
            <tr class="text-right">
                <td colspan="3" class="text-right" style="text-align: right; padding-right: 9px;font-size: 14px;">
                    <strong><?php echo app('translator')->get('quickadmin.customers.fields.closing_blance'); ?></strong>
                </td>
                <td style="font-size: 14px;">
                    <strong><span style="font-family: DejaVu Sans, sans-serif;">&#x20B9;</span> <?php echo e(number_format(abs($closingBalance),0)); ?> <?php echo e(($closingBalance >= 0 ) ? 'Dr' : 'Cr'); ?></strong>
                </td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    <footer>
        <table style="padding-left:8px;">
            <tr>
                <td style="margin: 0px; font-size:14px;" class="font-bold">
                <p>
                    <h4 style="margin:1px 0 0">THANK YOU</h4>
                </p>
                </td>
            </tr>
        </table>
    </footer>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.exports.pdf.layout.pdf', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/exports/pdf/statement_print.blade.php ENDPATH**/ ?>