<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo app('translator')->get('quickadmin.order.invoice'); ?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');
        body {
            /* font-family: Arial, sans-serif; */
            font-family: "Montserrat", sans-serif !important;
        }
        /* .MainBox {
            padding: 20px;
            border: 1px solid #aeb1c133;
            margin: 20px;
        } */
        .mainHeading h2 {
            text-align: center;
        }
        .sub_total_area {
            list-style: none;
            padding: 0;
        }
        .sub_total_area li {
            font-weight: 600;
            margin: 0 0px 15px;
            line-height: 16px;
            font-size: 16px;
            color: #2a2a2a;
        }
        .sub_total_area.right li {
            display: flex;
            justify-content: space-between;
        }
        .sub_total_area.right li label{
            text-align: left;
        }
        .sub_total_area li span{
            font-weight: 500;
            padding-left: 20px;
        }
        .sub_total_area li label{
            min-width: 90px;
            display: inline-block;
        }
        .table-group {
            margin-bottom: 40px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .table th, .table td {
            border: 1px solid #555;
            padding: 8px;
            text-align: left;
        }
        .top-invoice-details {
            display: flex;
            justify-content: space-between;
        }
        .footer-group .sub_total_area,
        .top-invoice-details .sub_total_area.right{
            max-width: 300px;
            width: 300px;
            margin-left: auto;
        }
        .footer-group .sub_total_area li{
            display: flex;
            justify-content: space-between;
        }
        .footer-group .sub_total_area li.subtotal{
            padding: 15px 0px;
            border-top: 1px solid #555;
            border-bottom: 1px solid #555;
            font-size: 20px;
            color: 000;
        }
        .footer-group .sub_total_area li.subtotal span{
            font-weight: 700;
        }
        .footer-group .remark{
            margin-top: 40px;
        }
        .small-text-gray {
            font-size: 10px; 
            color: #666;
        }
    </style>
</head>
<body>
    <div class="card MainBox ">
        <div class="mainHeading">
            <h2><?php echo app('translator')->get('quickadmin.order.invoice'); ?></h2>           
            <div class="top-invoice-details">            
                <ul class="sub_total_area left">
                    <li><label>Bill To : </label><span><?php echo e($order->customer->name ?? ''); ?></span></li>
                    <li><label>Address : </label><span><?php echo e($order->customer?->area?->address); ?></span></li>
                    <li><label>Phone no : </label><span><?php echo e($order->customer->phone_number ?? ''); ?></span></li>
                </ul>                            
                <ul class="sub_total_area right">
                    <li><label><?php echo app('translator')->get('quickadmin.order.fields.invoice_number'); ?> : </label><span>#<?php echo e($order->invoice_number); ?></span></li>
                    <li><label><?php echo app('translator')->get('quickadmin.order.fields.invoice_date'); ?> : </label><span><?php echo e($order->invoice_date->format('d-M-Y')); ?></span></li>
                    <li><label><?php echo app('translator')->get('quickadmin.order.fields.created_at'); ?> : </label><span><?php echo e($order->created_at->format('d-M-Y H:i A')); ?></span></li>                    
                </ul>                            
            </div>
        </div>
        <div class="table-group">
            <div class="table-responsive">
                <table class="table custom_table" id="orderProductTable">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('quickadmin.qa_sn'); ?></th>
                            <th><?php echo app('translator')->get('quickadmin.order.fields.product_name'); ?></th>
                            <th style="width: 140px;"><?php echo app('translator')->get('quickadmin.order.fields.dispatch_place'); ?></th>
                            <th><?php echo app('translator')->get('quickadmin.order.fields.quantity'); ?></th>
                            <th><?php echo app('translator')->get('quickadmin.order.fields.price'); ?></th>
                            <th style="width: 130px;"><?php echo app('translator')->get('quickadmin.order.fields.amount'); ?> (₹)</th>                                        
                        </tr> 
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->orderProduct()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($product->product->full_name); ?> </td>
                            <td><?php echo e(ucwords($product->dispatch_place)); ?></td>
                            <td><?php echo e($product->quantity); ?> <?php echo e($product->product ? $product->product->product_unit->name :''); ?></td>
                            <td><?php echo e($product->price); ?></td>
                            <td><?php echo e($product->total_price); ?></td>
                        </tr>    
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                        
                    </tbody>                                       
                </table>
            </div>
        </div> 
        <div class="footer-group">
            <ul class="sub_total_area">
                <li><label><?php echo app('translator')->get('quickadmin.order.fields.sub_total_amount'); ?> : </label> <span id="sub_total">₹ <?php echo e($order->sub_total ?? 0); ?></span></li>
                <li><label><?php echo app('translator')->get('quickadmin.order.fields.labour_bhada'); ?> : </label> <span id="labour_bhada">₹ <?php echo e($order->labour_bhada ?? 0); ?></span></li>
                <li><label><?php echo app('translator')->get('quickadmin.order.fields.gadi_bhada'); ?> : </label> <span id="gadi_bhada">₹ <?php echo e($order->gadi_bhada ?? 0); ?></span></li>
                <li class="subtotal"><label><?php echo app('translator')->get('quickadmin.order.fields.grand_total'); ?> : </label> <span id="grand_total">₹ <?php echo e($order->grand_total ?? 0); ?></span></li>
            </ul>  
            <div class="remark">
                <?php if($order->remark): ?>
                    <label for="remark"><?php echo app('translator')->get('quickadmin.order.fields.remark'); ?> : </label>
                    <span id="remark"><?php echo e($order->remark ?? " "); ?></span>    
                <?php endif; ?>                                
            </div>
        </div>       
        
    </div>
</body>
</html>
<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/order/_print_order.blade.php ENDPATH**/ ?>