<div class="modal fade px-2" id="inventoryViewModal" tabindex="-1" role="dialog" aria-labelledby="editModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalCenterTitle"><?php echo app('translator')->get('quickadmin.inventory.view'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body floatingLabel">
                <ul class="dataShowing">
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.inventory.select_product'); ?></label>
                        <span class="text-capitalize"><?php echo e($shiftingGood->product->name ?? $inventory->product->name); ?></span>
                    </li>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.inventory.fields.quantity'); ?></label>
                        <?php if(isset($inventory)): ?>
                            <span><?php echo e((int)$inventory->quantity); ?></span>
                        <?php else: ?>
                            <span><?php echo e((int)$shiftingGood->quantity); ?></span>
                        <?php endif; ?>
                    </li>
                    <?php if(isset($inventory)): ?>
                        <li>
                            <label><?php echo app('translator')->get('quickadmin.inventory.fields.area_id'); ?></label>
                            <span class="text-capitalize"><?php echo e(config('app.product_place.'.$inventory->place) ?? ''); ?></span>
                        </li>
                    <?php else: ?>
                        <li>
                            <label><?php echo app('translator')->get('quickadmin.inventory.fields.from'); ?></label>
                            <span class="text-capitalize"><?php echo e(config('app.product_place.'.$shiftingGood->from) ?? ''); ?></span>
                        </li>
                        <li>
                            <label><?php echo app('translator')->get('quickadmin.inventory.fields.to'); ?></label>
                            <span class="text-capitalize"><?php echo e(config('app.product_place.'.$shiftingGood->to) ?? ''); ?></span>
                        </li>
                    <?php endif; ?>
                    <li>
                        <label><?php echo app('translator')->get('quickadmin.inventory.fields.entry_date'); ?></label>
                        <?php if(isset($inventory)): ?>
                        <span><?php echo e($inventory->entry_date ? $inventory->entry_date->format('d-m-Y') : ""); ?></span>
                        <?php else: ?>
                        <span><?php echo e($shiftingGood->entry_date ? $shiftingGood->entry_date->format('d-m-Y') : ""); ?></span>
                        <?php endif; ?>
                    </li>
                    <?php if(isset($inventory) && !empty($inventory->remark)): ?>
                        <li>
                            <label><?php echo app('translator')->get('quickadmin.inventory.fields.remark'); ?></label>
                            <span class="text-capitalize"><?php echo e($inventory->remark ?? ''); ?></span>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/hipldemo2/public_html/billing-software.hipl-staging2.com/resources/views/admin/inventory/view.blade.php ENDPATH**/ ?>