@extends('layouts.auth')
@section('title') Reset Password @endsection

@section('main-content')
<section class="section auth_pages">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-12 col-lg-7">
          {{-- <div class="login-brand login-brand-color">
            <img alt="@lang('quickadmin.qa_company_name')" src="{{asset('admintheme/assets/img/logo.png') }}" height="80" width="80"/> 
            <span>{{ getSetting('company_name') ?? ''}}</span>
          </div>--}}
          
          <div class="card loginauth">
                <div class="card-header card-header-auth p-0">
                  <h4>@lang('quickadmin.qa_reset_password')</h4>
                </div>
                <div class="card-body p-0">
                    <form method="POST" action="{{route('reset-new-password')}}" id="ResetPassForm">                       
                        <input type="hidden" name="token" value="{{ $token }}">
                        <input type="hidden" name="email" value="{{ $email }}" >
                        <div class="form-group mb-4">
                          <label for="password">@lang('quickadmin.qa_new_password')</label>
                          <div class="input-group">
                            <div class="input-group-prepend">
                              <div class="input-group-text">
                                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="20" viewBox="0 0 15 20" fill="none">
                                  <path d="M7.5 0C4.375 0 1.875 2.5 1.875 5.625V8.125C0.8125 8.125 0 8.9375 0 10V18.125C0 19.1875 0.8125 20 1.875 20H13.125C14.1875 20 15 19.1875 15 18.125V10C15 8.9375 14.1875 8.125 13.125 8.125V5.625C13.125 2.5 10.625 0 7.5 0ZM13.75 10V18.125C13.75 18.5 13.5 18.75 13.125 18.75H1.875C1.5 18.75 1.25 18.5 1.25 18.125V10C1.25 9.625 1.5 9.375 1.875 9.375H2.5H12.5H13.125C13.5 9.375 13.75 9.625 13.75 10ZM3.125 8.125V5.625C3.125 3.1875 5.0625 1.25 7.5 1.25C9.9375 1.25 11.875 3.1875 11.875 5.625V8.125H3.125Z" fill="#062142"/>
                                  <path d="M7.5 11.25C6.4375 11.25 5.625 12.0625 5.625 13.125C5.625 13.9375 6.125 14.625 6.875 14.875V16.25C6.875 16.625 7.125 16.875 7.5 16.875C7.875 16.875 8.125 16.625 8.125 16.25V14.875C8.875 14.625 9.375 13.9375 9.375 13.125C9.375 12.0625 8.5625 11.25 7.5 11.25ZM7.5 13.75C7.125 13.75 6.875 13.5 6.875 13.125C6.875 12.75 7.125 12.5 7.5 12.5C7.875 12.5 8.125 12.75 8.125 13.125C8.125 13.5 7.875 13.75 7.5 13.75Z" fill="#062142"/>
                                </svg>
                              </div>
                            </div>
                            <input type="password" value="{{ old('password') }}" id="password" class="form-control  @error('password') is-invalid @enderror" name="password" tabindex="1" placeholder="New Password">
                            <span class="password-toggle-icon pass-toggle-icon"><i class="fas fa-eye" onClick="ChangeEyeIcon($(this),'password');"></i></span>
                            @error('password')
                            <div class="invalid-feedback">
                              {{ $message }}
                            </div>
                            @enderror
                          </div>
                        </div>
                        <div class="form-group">
                          <label for="password_confirmation">@lang('quickadmin.qa_confirm_password')</label>
                          <div class="input-group">
                            <div class="input-group-prepend">
                              <div class="input-group-text">
                                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="20" viewBox="0 0 15 20" fill="none">
                                  <path d="M7.5 0C4.375 0 1.875 2.5 1.875 5.625V8.125C0.8125 8.125 0 8.9375 0 10V18.125C0 19.1875 0.8125 20 1.875 20H13.125C14.1875 20 15 19.1875 15 18.125V10C15 8.9375 14.1875 8.125 13.125 8.125V5.625C13.125 2.5 10.625 0 7.5 0ZM13.75 10V18.125C13.75 18.5 13.5 18.75 13.125 18.75H1.875C1.5 18.75 1.25 18.5 1.25 18.125V10C1.25 9.625 1.5 9.375 1.875 9.375H2.5H12.5H13.125C13.5 9.375 13.75 9.625 13.75 10ZM3.125 8.125V5.625C3.125 3.1875 5.0625 1.25 7.5 1.25C9.9375 1.25 11.875 3.1875 11.875 5.625V8.125H3.125Z" fill="#062142"/>
                                  <path d="M7.5 11.25C6.4375 11.25 5.625 12.0625 5.625 13.125C5.625 13.9375 6.125 14.625 6.875 14.875V16.25C6.875 16.625 7.125 16.875 7.5 16.875C7.875 16.875 8.125 16.625 8.125 16.25V14.875C8.875 14.625 9.375 13.9375 9.375 13.125C9.375 12.0625 8.5625 11.25 7.5 11.25ZM7.5 13.75C7.125 13.75 6.875 13.5 6.875 13.125C6.875 12.75 7.125 12.5 7.5 12.5C7.875 12.5 8.125 12.75 8.125 13.125C8.125 13.5 7.875 13.75 7.5 13.75Z" fill="#062142"/>
                                </svg>
                              </div>
                            </div>
                            <input type="password" value="{{ old('password_confirmation') }}" id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation" tabindex="1" placeholder="Confirm Password">
                            <span class="confirm-password-toggle-icon pass-toggle-icon"><i class="fas fa-eye" onClick="ChangeEyeIcon($(this),'password_confirmation');"></i></span>
                            @error('password_confirmation')
                            <div class="invalid-feedback">
                              {{ $message }}
                            </div>
                            @enderror
                          </div>
                        </div>
                        
                        <div class="form-group mt-4">
                          <button type="submit" class="btn btn-auth-color btn-lg btn-block" tabindex="4">
                              @lang('quickadmin.qa_reset_password')
                          </button>
                        </div>
                    </form>
                    <div class="forgotpass text-center">
                      <a href="{{ route('login') }}" class="text-medium">
                          Back to Login
                      </a>
                    </div>
                </div>
          </div>
        </div>
      </div>
    </div>
  </section>

@endsection


@section('customJS')

<script type="text/javascript">
function ChangeEyeIcon(em,id) {
  em.toggleClass("fa-eye fa-eye-slash");
  var input = $("#"+id);
  if (input.attr("type") === "password") {
    input.attr("type", "text");
  } else {
    input.attr("type", "password");
  }
}
$(document).ready(function () {

  $(document).on('submit', '#ResetPassForm', function (e) {
        e.preventDefault();        
        $("#ResetPassForm button[type=submit]").prop('disabled',true);
        $(".error").remove();
        showLoader();
        var formData = $(this).serialize();
        var formAction = $(this).attr('action');
        $.ajax({
            url: formAction,
            type: 'POST',
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: formData,
            success: function (response) {    
              hideLoader();  
              if(response.success)
              {
                var alertType = response['alert-type'];
                var message = response['message'];
                var title = response['title'];
                var redirect_url = response['redirect_url'];
                $("#ResetPassForm button[type=submit]").prop('disabled',false);
                $('#ResetPassForm')[0].reset();
                showToaster('Password',alertType,message);                
                // window.location.href = redirect_url;
              }               
            },
            error: function (xhr) {
              hideLoader();
              $("#ResetPassForm button[type=submit]").prop('disabled',false);               
              if(xhr.responseJSON.success == false){
                var response = xhr.responseJSON;
                showToaster(response['title'],response['alert-type'],response['message']);
              }
              
              if(xhr.responseJSON.errors){
                var errors= xhr.responseJSON.errors;
                for (const elementId in errors) {                  
                  var errorHtml = '<div><span class="error text-danger">'+errors[elementId]+'</span></div>';
                  $(errorHtml).insertAfter($("#"+elementId).parent());
                }
              } 
              
              var mainError = xhr.responseJSON;
              var alertType = mainError['alert-type'];
              var message = mainError['message'] ?? 'Oops, Something Went Wrong!';
              var title = mainError['title'] ?? "Reset Failed";        
              swal(title, message, 'error'); 
            }
        });
  });    
  
});

</script>
@endsection