@extends('layouts.auth')
@section('title') Forgot Password @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
@endsection

@section('main-content')
<section class="section auth_pages">
    <div class="container">
       <div class="row justify-content-center">
        <div class="col-12 col-lg-7">
          {{-- <div class="login-brand login-brand-color">
            <img alt="@lang('quickadmin.qa_company_name')" src="{{asset('admintheme/assets/img/logo.png') }}" height="80" width="80"/>
            <span>{{ getSetting('company_name') ?? ''}}</span>
          </div> --}}
          
          @if (Session::has('error'))
          <div class="alert alert-danger alert-dismissible show fade">
              <div class="alert-body">
                <button class="close" data-dismiss="alert">
                  <span>×</span>
                </button>
                {{ Session::get('error') }}    </div>
          </div>
          @endif
          <div class="card loginauth">
                <div class="card-header card-header-auth p-0">
                  <h4>@lang('quickadmin.qa_forgot_password')</h4>
                </div>                
                <div class="card-body p-0">
                <p class="text-muted">@lang('quickadmin.qa_otp_line')</p>
                <form method="POST" action="{{ route("password_mail_link") }}" id="ForgotPassForm">                    
                    <div class="form-group">
                        <label for="email">@lang('quickadmin.qa_email')</label>
                        <div class="input-group">
                          <div class="input-group-prepend">
                            <div class="input-group-text">
                              <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                                <path d="M16.0356 7.79177L16.0366 7.79083L16.0673 7.76014L16.1287 7.69875C16.19 7.63741 16.2484 7.5792 16.3359 7.52083L16.3365 7.52165L16.3435 7.51458L16.4356 7.42249L16.5271 7.33099L17.0177 6.87111L17.0177 6.87113L17.0188 6.86999C17.153 6.73578 17.2219 6.53233 17.1537 6.32771L17.1542 6.32755L17.151 6.32116L17.1049 6.22908L17.0589 6.13699L17.0553 6.12973L17.0495 6.124C16.88 5.95451 16.611 5.92135 16.4086 6.02255L16.4014 6.02618L16.3956 6.03191C16.3866 6.04095 16.3779 6.04558 16.3626 6.05324L16.3614 6.05382C16.3463 6.06137 16.3252 6.07192 16.3043 6.09255L15.9064 6.45983C15.9063 6.45989 15.9063 6.45996 15.9062 6.46002C15.2928 7.0121 14.687 7.55651 14.0813 8.10093L14.0801 8.10197C13.4739 8.64678 12.8677 9.19161 12.2538 9.74411C12.2538 9.74413 12.2538 9.74414 12.2537 9.74416L11.8396 10.1123L11.4259 10.48C11.4258 10.4801 11.4257 10.4802 11.4256 10.4803C11.005 10.8407 10.4949 11.0205 9.98509 11.0205C9.47453 11.0205 8.99535 10.8709 8.54473 10.4804C8.54465 10.4803 8.54457 10.4803 8.54449 10.4802L8.13059 10.1123L7.71644 9.74416C7.71639 9.74412 7.71635 9.74408 7.71631 9.74404C7.10273 9.19182 6.49682 8.64727 5.89093 8.10273L5.89008 8.10197C5.28393 7.55721 4.6778 7.01246 4.06401 6.46004L3.66588 6.09254C3.64501 6.07192 3.62388 6.06137 3.60876 6.05382C3.60838 6.05362 3.60799 6.05343 3.60761 6.05324C3.59228 6.04558 3.58361 6.04095 3.57457 6.03191L3.57527 6.03121L3.56694 6.02567C3.35721 5.88584 3.08558 5.95907 2.92066 6.124C2.85658 6.18807 2.81727 6.25814 2.81413 6.33372C2.78194 6.42084 2.78373 6.52068 2.80787 6.61321C2.83288 6.70908 2.883 6.80164 2.95135 6.86999L2.95133 6.87001L2.95251 6.87111L3.44303 7.33098L3.62663 7.51458L3.62738 7.51532C3.68771 7.57566 3.75105 7.63899 3.84496 7.70221L3.90289 7.76014L3.93358 7.79083L3.93357 7.79084L3.93455 7.79177C4.33247 8.16875 4.74516 8.53191 5.15186 8.8898C5.34188 9.05701 5.5306 9.22307 5.71589 9.38886L5.71588 9.38887L5.71669 9.38956C5.82322 9.48087 5.92991 9.57994 6.04129 9.68363L6.0534 9.69491C6.14869 9.78363 6.24737 9.87552 6.35149 9.9678L6.34887 9.97042L6.34869 9.9706L6.34851 9.97078L6.34833 9.97096L6.34815 9.97114L6.34743 9.97186L6.34599 9.9733L6.34581 9.97348L6.34563 9.97366L6.34545 9.97384L6.34527 9.97402L6.34509 9.9742L6.34491 9.97438L6.34455 9.97474L6.34419 9.9751L6.34401 9.97528L6.34383 9.97546L6.34365 9.97564L6.34347 9.97582L6.34311 9.97618L6.34167 9.97762L6.34131 9.97798L6.34113 9.97816L6.34095 9.97834L6.34023 9.97905L6.33736 9.98193L6.3316 9.98769L6.32872 9.99057L6.32585 9.99344L6.32441 9.99488L6.32297 9.99632L6.32153 9.99776L6.32117 9.99812L6.32081 9.99848L6.32045 9.99884L6.32027 9.99902L6.32009 9.9992L6.31434 10.005L6.31416 10.0051L6.31398 10.0053L6.3138 10.0055L6.31362 10.0057L6.3129 10.0064L6.31272 10.0066L6.31254 10.0068L6.31236 10.0069L6.31218 10.0071L6.31182 10.0075L6.31146 10.0078L6.30858 10.0107L6.3057 10.0136L6.30552 10.0138L6.30534 10.0139L6.30498 10.0143L6.3048 10.0145L6.30462 10.0147L6.30426 10.015L6.3039 10.0154L6.30372 10.0156L6.30354 10.0157L6.30318 10.0161L6.303 10.0163L6.30282 10.0165L6.30211 10.0172L6.30139 10.0179L6.29995 10.0193L6.29851 10.0208L6.29707 10.0222C5.82147 10.4978 5.34586 10.9658 4.87007 11.4339L4.87006 11.4339L4.86994 11.434C4.39423 11.902 3.91836 12.3702 3.44247 12.8461L3.38108 12.9075L3.31969 12.9689L3.31947 12.9687L3.316 12.973C3.17889 13.1444 3.17972 13.3822 3.28147 13.5518L3.28108 13.552L3.2853 13.5573C3.41451 13.7188 3.6212 13.8304 3.83462 13.7259C3.93302 13.6923 4.03191 13.6267 4.09954 13.5277C4.57421 13.0683 5.04886 12.6013 5.52333 12.1345L5.52339 12.1344C5.99918 11.6663 6.4748 11.1983 6.95039 10.7381L6.9504 10.7381L6.95098 10.7375L6.95134 10.7372L6.9517 10.7368L6.95205 10.7364L6.95241 10.7361L6.95277 10.7357L6.95312 10.7354L6.95348 10.735L6.95383 10.7347L6.95419 10.7343L6.95454 10.734L6.95489 10.7336L6.95525 10.7333L6.9556 10.7329L6.95595 10.7326L6.9563 10.7322L6.95665 10.7319L6.95699 10.7315L6.95734 10.7312L6.95769 10.7308L6.95804 10.7305L6.95838 10.7301L6.95873 10.7298L6.95907 10.7294L6.95942 10.7291L6.95976 10.7287L6.9601 10.7284L6.96044 10.7281L6.96078 10.7277L6.96113 10.7274L6.96147 10.727L6.96181 10.7267L6.96214 10.7264L6.96248 10.726L6.96282 10.7257L6.96316 10.7253L6.96349 10.725L6.96383 10.7247L6.96417 10.7243L6.9645 10.724L6.96483 10.7237L6.96517 10.7233L6.9655 10.723L6.96583 10.7227L6.96616 10.7223L6.9665 10.722L6.96683 10.7217L6.96716 10.7213L6.96749 10.721L6.96781 10.7207L6.96814 10.7204L6.96847 10.72L6.9688 10.7197L6.96912 10.7194L6.96945 10.719L6.96978 10.7187L6.9701 10.7184L6.97043 10.7181L6.97075 10.7177L6.97107 10.7174L6.9714 10.7171L6.97172 10.7168L6.97204 10.7165L6.97236 10.7161L6.97268 10.7158L6.973 10.7155L6.97332 10.7152L6.97364 10.7149L6.97396 10.7145L6.97428 10.7142L6.97459 10.7139L6.97491 10.7136L6.97523 10.7133L6.97554 10.713L6.97586 10.7126L6.97617 10.7123L6.97649 10.712L6.9768 10.7117L6.97712 10.7114L6.97743 10.7111L6.97774 10.7108L6.97805 10.7104L6.97836 10.7101L6.97868 10.7098L6.97899 10.7095L6.9793 10.7092L6.97961 10.7089L6.97992 10.7086L6.98022 10.7083L6.98053 10.708L6.98084 10.7077L6.98115 10.7073L6.98145 10.707L6.98176 10.7067L6.98207 10.7064L6.98237 10.7061L6.98268 10.7058L6.98298 10.7055L6.98329 10.7052L6.98359 10.7049L6.98389 10.7046L6.9842 10.7043L6.9845 10.704L6.9848 10.7037L6.9851 10.7034L6.9854 10.7031L6.9857 10.7028L6.98601 10.7025L6.98631 10.7022L6.98661 10.7019L6.9869 10.7016L6.9872 10.7013L6.9875 10.701L6.9878 10.7007L6.9881 10.7004L6.98839 10.7001L6.98869 10.6998L6.98899 10.6995L6.98928 10.6992L6.98958 10.6989L6.98987 10.6986L6.99017 10.6983L6.99046 10.698L6.99076 10.6977L6.99105 10.6974L6.99135 10.6972L6.99164 10.6969L6.99193 10.6966L6.99222 10.6963L6.99252 10.696L6.99281 10.6957L6.9931 10.6954L6.99339 10.6951L6.99368 10.6948L6.99397 10.6945L6.99426 10.6942L6.99455 10.6939L6.99484 10.6937L6.99513 10.6934L6.99542 10.6931L6.99571 10.6928L6.996 10.6925L6.99628 10.6922L6.99657 10.6919L6.99686 10.6916L6.99714 10.6914L6.99743 10.6911L6.99772 10.6908L6.998 10.6905L6.99829 10.6902L6.99857 10.6899L6.99886 10.6896L6.99914 10.6894L6.99943 10.6891L6.99971 10.6888L7 10.6885L7.00028 10.6882L7.00056 10.6879L7.00085 10.6877L7.00113 10.6874L7.00141 10.6871L7.00169 10.6868L7.00198 10.6865L7.00226 10.6862L7.00254 10.686L7.00282 10.6857L7.0031 10.6854L7.00338 10.6851L7.00366 10.6848L7.00394 10.6846L7.00422 10.6843L7.0045 10.684L7.00478 10.6837L7.00506 10.6834L7.00534 10.6832L7.00562 10.6829L7.0059 10.6826L7.00618 10.6823L7.00646 10.682L7.00673 10.6818L7.00701 10.6815L7.00729 10.6812L7.00757 10.6809L7.00784 10.6807L7.00812 10.6804L7.0084 10.6801L7.00867 10.6798L7.00895 10.6795L7.00923 10.6793L7.0095 10.679L7.00978 10.6787L7.01005 10.6784L7.01033 10.6782L7.0106 10.6779L7.01088 10.6776L7.01116 10.6773L7.01143 10.6771L7.0117 10.6768L7.01198 10.6765L7.01225 10.6762L7.01253 10.676L7.0128 10.6757L7.01308 10.6754L7.01335 10.6751L7.01362 10.6749L7.0139 10.6746L7.01417 10.6743L7.01444 10.6741L7.01472 10.6738L7.01499 10.6735L7.01526 10.6732L7.01553 10.673L7.01581 10.6727L7.01608 10.6724L7.01635 10.6721L7.01662 10.6719L7.01689 10.6716L7.01717 10.6713L7.01744 10.6711L7.01771 10.6708L7.01798 10.6705L7.01825 10.6702L7.01853 10.67L7.0188 10.6697L7.01907 10.6694L7.01934 10.6692L7.01961 10.6689L7.01988 10.6686L7.02015 10.6683L7.02042 10.6681L7.02069 10.6678L7.02096 10.6675L7.02123 10.6673L7.0215 10.667L7.02178 10.6667L7.02205 10.6665L7.02232 10.6662L7.02259 10.6659L7.02286 10.6656L7.02313 10.6654L7.0234 10.6651L7.02367 10.6648L7.02394 10.6646L7.02421 10.6643L7.02448 10.664L7.02475 10.6638L7.02502 10.6635L7.02529 10.6632L7.02556 10.6629L7.02583 10.6627L7.0261 10.6624L7.02637 10.6621L7.02664 10.6619L7.02691 10.6616L7.02718 10.6613L7.02745 10.6611L7.02772 10.6608L7.02799 10.6605L7.02825 10.6602L7.02852 10.66L7.02879 10.6597L7.02906 10.6594L7.02933 10.6592L7.0296 10.6589L7.02987 10.6586L7.03014 10.6584L7.03041 10.6581L7.03068 10.6578L7.03095 10.6575L7.03122 10.6573L7.03149 10.657L7.03176 10.6567L7.03203 10.6565L7.0323 10.6562L7.03257 10.6559L7.03284 10.6557L7.03311 10.6554L7.03338 10.6551L7.03366 10.6548L7.03393 10.6546L7.0342 10.6543L7.03447 10.654L7.03474 10.6538L7.03501 10.6535L7.03528 10.6532L7.03555 10.6529L7.03582 10.6527L7.03609 10.6524L7.03636 10.6521L7.03663 10.6519L7.03691 10.6516L7.03718 10.6513L7.03745 10.651L7.03772 10.6508L7.03799 10.6505L7.03826 10.6502L7.03854 10.65L7.03881 10.6497L7.03908 10.6494L7.03935 10.6491L7.03962 10.6489L7.0399 10.6486L7.04017 10.6483L7.04044 10.6481L7.04072 10.6478L7.04099 10.6475L7.04126 10.6472L7.04153 10.647L7.04181 10.6467L7.04208 10.6464L7.04236 10.6461L7.04263 10.6459L7.0429 10.6456L7.04318 10.6453L7.04345 10.645L7.04373 10.6448L7.044 10.6445L7.04428 10.6442L7.04455 10.6439L7.04483 10.6437L7.0451 10.6434L7.04538 10.6431L7.04565 10.6428L7.04593 10.6426L7.0462 10.6423L7.04648 10.642L7.04676 10.6417L7.04703 10.6415L7.04731 10.6412L7.04759 10.6409L7.04786 10.6406L7.04814 10.6404L7.04842 10.6401L7.0487 10.6398L7.04897 10.6395L7.04925 10.6392L7.04953 10.639L7.04981 10.6387L7.05009 10.6384L7.05037 10.6381L7.05065 10.6378L7.05093 10.6376L7.05121 10.6373L7.05149 10.637L7.05177 10.6367L7.05205 10.6364L7.05233 10.6362L7.05261 10.6359L7.05289 10.6356L7.05317 10.6353L7.05345 10.635L7.05374 10.6348L7.05402 10.6345L7.0543 10.6342L7.05458 10.6339L7.05487 10.6336L7.05515 10.6333L7.05543 10.6331L7.05572 10.6328L7.056 10.6325L7.05629 10.6322L7.05657 10.6319L7.05686 10.6316L7.05714 10.6314L7.05743 10.6311L7.05771 10.6308L7.058 10.6305L7.05829 10.6302L7.05857 10.6299L7.05886 10.6296L7.05915 10.6293L7.05944 10.6291L7.05972 10.6288L7.06001 10.6285L7.0603 10.6282L7.06059 10.6279L7.06088 10.6276L7.06117 10.6273L7.06146 10.627L7.06175 10.6267L7.06204 10.6265L7.06233 10.6262L7.06262 10.6259L7.06291 10.6256L7.06321 10.6253L7.0635 10.625L7.06379 10.6247L7.06408 10.6244L7.06438 10.6241L7.06467 10.6238L7.06497 10.6235L7.06526 10.6232L7.06556 10.6229L7.06585 10.6226L7.06615 10.6224L7.06644 10.6221L7.06674 10.6218L7.06704 10.6215L7.06733 10.6212L7.06763 10.6209L7.06793 10.6206L7.06823 10.6203L7.06853 10.62L7.06883 10.6197L7.06913 10.6194L7.06943 10.6191L7.06973 10.6188L7.07003 10.6185L7.07033 10.6182L7.07063 10.6179L7.07093 10.6176L7.07113 10.6174C7.33304 10.8499 7.56805 11.0555 7.8029 11.261C8.30204 11.7287 8.92614 12.0095 9.61223 12.0718L9.61221 12.072H9.61675C9.67451 12.072 9.73279 12.0793 9.79472 12.087L9.79618 12.0872C9.8566 12.0947 9.92058 12.1027 9.98509 12.1027H9.98774C10.1076 12.1027 10.2343 12.1027 10.3618 12.0715C11.0485 12.0081 11.6397 11.6956 12.1655 11.2626L12.1655 11.2626L12.1666 11.2616C12.2527 11.1863 12.3377 11.1083 12.4235 11.0295C12.5761 10.8894 12.7311 10.7471 12.8984 10.6144C12.9112 10.6257 12.9238 10.636 12.9351 10.6453C12.943 10.6518 12.9503 10.6578 12.9568 10.6634C12.9822 10.6852 12.9991 10.703 13.0098 10.7245L13.0137 10.7322L13.0198 10.7381C13.4954 11.1983 13.971 11.6663 14.4468 12.1344L14.4468 12.1344L14.447 12.1346C14.9226 12.6026 15.3985 13.0708 15.8744 13.5313C15.9048 13.5617 15.9446 13.6016 15.9888 13.6377C16.0328 13.6737 16.0844 13.7088 16.1389 13.727C16.3445 13.7955 16.5501 13.7258 16.6849 13.5573C16.8265 13.3803 16.7869 13.1389 16.6542 12.973L16.6544 12.9728L16.6505 12.9689L16.5891 12.9075L16.5277 12.8461C16.0518 12.3702 15.5759 11.902 15.1002 11.434L15.1001 11.4339L15.1 11.4337C14.6242 10.9657 14.1487 10.4978 13.6731 10.0222L13.6271 9.97618L13.6165 9.96563C13.7942 9.79071 13.9731 9.63451 14.1721 9.46071C14.199 9.43723 14.2262 9.41343 14.2539 9.38923L14.2543 9.38886C14.4396 9.22307 14.6283 9.05701 14.8183 8.8898C15.225 8.53191 15.6377 8.16875 16.0356 7.79177Z" fill="#062142" stroke="#062142" stroke-width="0.1"/>
                                <path d="M19.55 14.0796V14.0786V5.66821C19.55 4.10587 18.2691 2.825 16.7068 2.825H3.29321C1.73087 2.825 0.45 4.10587 0.45 5.66821V14.0786C0.45 15.6409 1.73087 16.9218 3.29321 16.9218H16.6761C18.2697 16.9218 19.5188 15.6406 19.55 14.0796ZM1.59362 5.66821C1.59362 4.74372 2.33917 3.96862 3.29321 3.96862H16.7068C17.6313 3.96862 18.4064 4.71417 18.4064 5.66821V14.0786C18.4064 15.003 17.6608 15.7782 16.7068 15.7782H3.29321C2.36872 15.7782 1.59362 15.0326 1.59362 14.0786V5.66821Z" fill="#062142" stroke="#062142" stroke-width="0.1"/>
                              </svg>
                            </div>
                          </div>
                          <input type="email" value="{{ old('email') }}" id="email" class="form-control @error('email') is-invalid @enderror" name="email" tabindex="1" placeholder="Email Address">                          
                        </div>
                    </div>
                    <div class="form-group mt-4">
                      <button type="submit" class="btn btn-lg btn-block btn-auth-color" tabindex="4">
                          @lang('quickadmin.qa_submit')
                      </button>
                    </div>
                </form>

                <div class="forgotpass text-center">
                  <a href="{{ route('login') }}" class="text-medium">
                      Back to Login
                  </a>
                </div>
                </div>
          </div>

        </div>
      </div>
    </div>
  </section>

@endsection

@section('customJS')

<script type="text/javascript">

$(document).ready(function () {

  $(document).on('submit', '#ForgotPassForm', function (e) {
        e.preventDefault();        
        $("#ForgotPassForm button[type=submit]").prop('disabled',true);
        $(".error").remove();
        showLoader();
        var formData = $(this).serialize();
        var formAction = $(this).attr('action');
        $.ajax({
            url: formAction,
            type: 'POST',
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: formData,
            success: function (response) {    
              hideLoader();  
              if(response.success)
              {
                var alertType = response['alert-type'];
                var message = response['message'];
                var title = response['title'];
                $("#ForgotPassForm button[type=submit]").prop('disabled',false);
                $('#ForgotPassForm')[0].reset();
                showToaster('Reset Link',alertType,message);
              }               
            },
            error: function (xhr) {
              hideLoader();
              $("#ForgotPassForm button[type=submit]").prop('disabled',false);               
              if(xhr.responseJSON.success == false){
                var response = xhr.responseJSON;
                showToaster(response['title'],response['alert-type'],response['message']);
              }
              
              if(xhr.responseJSON.errors){
                var errors= xhr.responseJSON.errors;
                for (const elementId in errors) {                  
                  var errorHtml = '<div><span class="error text-danger">'+errors[elementId]+'</span></div>';
                  $(errorHtml).insertAfter($("#"+elementId).parent());
                }
              }     
              
              var mainError = xhr.responseJSON;
              var alertType = mainError['alert-type'];
              var message = mainError['message'] ?? 'Oops, Something Went Wrong!';
              var title = mainError['title'] ?? "Process Failed";        
              swal(title, message, 'error'); 
            }
        });
  });    

});

</script>
@endsection