    <div class="row">
        <div class="col-sm-6 col-md-6">
            <div class="form-group">
                <label for="name">@lang('quickadmin.users.fields.name')<span class="text-danger">*</span></label>
                <div class="input-group">
                    <input type="text" class="form-control" name="name" value="{{ isset($user) ? $user->name : old('name') }}" id="name" autocomplete="true" placeholder="Enter Name">
                </div>
            </div>
        </div>
        {{-- <div class="col-md-6">
            <div class="form-group">
                <label for="username">@lang('quickadmin.users.fields.usernameid')</label>
                <div class="input-group">
                    <input type="text" class="form-control" name="username" value="{{ isset($user) ? $user->username : old('username') }}" id="username" autocomplete="true" onkeypress="return event.charCode != 32">
                </div>
            </div>
        </div> --}}
    
        <div class="col-sm-6 col-md-6">
            <div class="form-group">
                <label for="email">@lang('quickadmin.users.fields.email')<span class="text-danger">*</span></label>
                <div class="input-group">
                    <input type="text" class="form-control" name="email" value="{{ isset($user) ? $user->email : old('email') }}" id="email" autocomplete="true" placeholder="Enter Email ID">
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="form-group">
                <label for="phone">@lang('quickadmin.users.fields.phone')</label>
                <div class="input-group">
                    <input type="text" class="form-control" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*?)\..*/g, '$1');" name="phone" value="{{ isset($user) ? $user->phone : old('phone') }}" id="phone" autocomplete="true" placeholder="Enter Contact Number">
                </div>
            </div>
        </div>
    
        <div class="col-sm-6 col-md-6">
            <div class="form-group">
                <label for="role_id">@lang('quickadmin.users.fields.role')<span class="text-danger">*</span></label>
                <div class="input-group">
                    <select class="form-control @error('role_id') is-invalid @enderror" name="role_id" id="role_id" >
                        <option value="{{ isset($user) ? $user->roles->first()->id : old('role_id') }}">
                            {{ isset($user) ? $user->roles->first()->name : 'Select Role' }}
                        </option>
                        @foreach($roles as $rolee)
                        @if (!isset($user) || $user->roles->first()->id !== $rolee->id)
                            <option value="{{ $rolee->id }}">{{ $rolee->name }}</option>
                        @endif
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    
    @isset($user)

    @else    
        <div class="col-sm-6 col-md-6">
            <div class="form-group">
                <label for="password">@lang('quickadmin.qa_new_password')<span class="text-danger">*</span></label>
                <div class="input-group">
                    <input type="password" value="{{ old('password') }}" id="password" class="form-control @error('password') is-invalid @enderror" name="password" tabindex="1" placeholder="Enter New Password" autofocus>
                    <span class="password-toggle-icon"><i class="fas fa-eye" onClick="ChangeEyeIcon($(this),'password');"></i></span>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="form-group">
                <label for="password_confirmation">@lang('quickadmin.qa_confirm_password')<span class="text-danger">*</span></label>
                <div class="input-group">
                    <input type="password" value="{{ old('password_confirmation') }}" id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation" tabindex="1" placeholder="Enter Confirm Password" autofocus>
                    <span class="confirm-password-toggle-icon"><i class="fas fa-eye" onClick="ChangeEyeIcon($(this),'password_confirmation');"></i></span>
                </div>
            </div>
        </div>    
    @endisset
    </div>

    <div class="row">
        <div class="col-md-12 text-right">
            <button type="submit" class="btn btn-primary" title="@lang('quickadmin.qa_submit')">@lang('quickadmin.qa_submit')</button>
        </div>
    </div>

