
<div class="col-sm-6 col-md-6">
    <div class="form-group">
        <label>@lang('admin_master.product.product_name') <span class="text-danger">*</span></label>
        <div class="input-group">
            <input type="text" class="form-control" name="name" value="{{ isset($product) ? $product->name : '' }}" id="name" autocomplete="true" placeholder="@lang('admin_master.product.product_name_enter')">
        </div>
        <div class="error_name text-danger error"></div>
    </div>
</div>

<div class="col-sm-6 col-md-6">
    <div class="form-group">
        <label>@lang('admin_master.product.calculation') <span class="text-danger">*</span></label>
        <div class="input-group">
            <input type="text" class="form-control only_integer" name="calculation" value="{{ isset($product) ? $product->calculation : '' }}" id="calculation" autocomplete="false" placeholder="@lang('admin_master.product.calculation_enter')">
        </div>
        <div class="error_calculation text-danger error"></div>
    </div>
</div>

<div class="col-sm-6 col-md-6 fullselect2">
    <div class="form-group">
        <div class="group-flex d-flex">
            <label>@lang('admin_master.product.brand_type_name') <span class="text-danger">*</span></label>
            <div class="in-btn-column">
                @can('brand_create')
                    <button type="button" class="btn addRecordBtn addBtn add_brand sm_btn" title="New Brand" ><i class="fas fa-plus"></i>@lang('admin_master.product.new_brand')</button>
                @endcan 
            </div>
        </div>
        <div class="input-group">
            <select name="brand_id" class="form-control select2" id="brandList">
                <option value="" disabled selected>@lang('admin_master.product.select_brand')</option>
                @foreach($brands as $brand)
                    <option value="{{ $brand->id }}"  {{ isset($product) ? $product->brand_id == $brand->id ? 'selected' :'' :'' }} >{{ $brand->name ??'' }} </option>
                @endforeach
            </select>            
        </div>
        
        <div class="error_brand_id text-danger error"></div>
    </div>
</div>

<div class="col-sm-6 col-md-6 fullselect2">
    <div class="form-group unit_type">
        <div class="group-flex d-flex">
            <label>@lang('admin_master.product.unit_type') <span class="text-danger">*</span></label>
            <div class="in-btn-column">
                @can('unit_create')
                    <button type="button" class="btn addRecordBtn addBtn add_unit sm_btn" title="New Unit" ><i class="fas fa-plus"></i>@lang('admin_master.product.new_unit')</button>
                @endcan
            </div>
        </div>
        <div class="input-group">
            <select name="unit_type" class="form-control select2" id="unit_type">
                <option value="" disabled selected>@lang('admin_master.product.select_unit_type')</option>
                @foreach($product_units as $product_unit)
                    <option value="{{ $product_unit->id }}"  {{ isset($product) ? $product->unit_type == $product_unit->id ? 'selected' :'' :'' }} >{{ $product_unit->name ??'' }} </option>
                @endforeach
            </select>             
        </div>
        <div class="error_unit_type text-danger error"></div>
    </div>
</div>



<div class="col-md-12 text-right">
    @if(isset($product))
    <input type="button" class="btn btn-primary save_product_btn" value="@lang('admin_master.g_update')" title="@lang('admin_master.g_update')">
    @else
    <input type="button" class="btn btn-primary save_product_btn" value="@lang('admin_master.g_submit')" title="@lang('admin_master.g_submit')">
    @endif
</div>

