<div class="modal fade px-2" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="editModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalCenterTitle">@lang('quickadmin.qa_view') Cash Receipt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body floatingLabel">
                <ul class="dataShowing">
                    <li>
                        <label>@lang('quickadmin.order.fields.invoice_date')</label>
                        <span class="text-capitalize" field-key='entry_date'>{{ $transaction->entry_date->format('d-m-Y') }}</span>
                    </li>
                    @if(!empty($transaction->voucher_number))
                    <li>
                        <label>@lang('quickadmin.transaction.fields.voucher_number')</label>
                        <span class="text-capitalize" field-key='voucher_number'>#{{ $transaction->voucher_number ?? '' }}</span>
                    </li>
                    @endif
                    <li>
                        <label>@lang('quickadmin.transaction.fields.particulars')</label>
                        <span class="text-capitalize" field-key='remark'>{{ $transaction->remark ?? 'Cash Receipt' }}</span>
                    </li>
                    <li>
                        <label>@lang('quickadmin.transaction.fields.payment_type')</label>
                        <span class="text-capitalize" field-key='payment_type'>{{ $transaction->payment_type ? ucfirst($transaction->payment_type) : '' }}</span>
                    </li>
                    {{--<li>
                        <label>@lang('quickadmin.transaction.fields.payment_way')</label>
                        <span class="text-capitalize" field-key='payment_way'>{{ config('constant.paymentModifyWays')[$transaction->payment_way] }}</span>
                    </li>--}}
                    <li>
                        <label>@lang('quickadmin.qa_created_at')</label>
                        <span class="text-capitalize" field-key='created_at'>{{ $transaction->created_at->format('d-m-Y H:i A') }}</span>
                    </li>
                    <li>
                        <label>@lang('quickadmin.transaction.fields.amount')</label>
                        <span class="text-capitalize" field-key='amount'><i class="fa fa-inr" aria-hidden="true"></i> {{ number_format($transaction->amount,2) }}</span>
                    </li>
                    <li>
                        <label>@lang('quickadmin.transaction.fields.remark')</label>
                        <span class="text-capitalize" field-key='remark'>{{ $transaction->remark ?? '' }}</span>
                    </li>
                </ul>
                @if($transaction->cashReceiptAmounts->isNotEmpty())
                <div class="table-responsive mt-3">
                    <table class="table dataTable payment-transtion-table">
                        <thead>
                            <tr>
                                <th>@lang('quickadmin.transaction.fields.sn')</th>
                                <th>@lang('quickadmin.transaction.fields.payment_way')</th>
                                <th>@lang('quickadmin.transaction.fields.amount')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transaction->cashReceiptAmounts as $index => $row)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ config('constant.paymentModifyWays')[$row->payment_way] ?? $row->payment_way }}</td>
                                    <td>{{ number_format($row->amount, 2) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted">
                                        @lang('quickadmin.qa_no_entries_in_table')
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>



