<div class="modal fade invoiceModal" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" data-backdrop="static"data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">@lang('quickadmin.qa_view') @lang('quickadmin.order.invoice')</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="text-right print-bottom-btn mb-3">
                    @can('estimate_print')
                    <a href="{{ route('orders.print',$order->uuid) }}" class="btn btn-primary" id="order-detail-print" title="Print"> <x-svg-icon icon="print" />Print</a>
                    @endcan
                </div>
                <div class="invoce-details">
                    <div class="row">
                        <div class="col">
                            <ul class="sub_total_area left">
                                <li><label>@lang('quickadmin.bill_to')</label><span>{{ $order->customer->name ?? '' }}</span></li>
                                <li><label>@lang('quickadmin.customers.fields.area_address')</label><span>{{ $order->customer?->area?->address }}</span></li>
                                <li><label>@lang('quickadmin.customers.fields.phone_number')</label><span>{{ $order->customer->phone_number ?? '' }}</span></li>
                            </ul>                            
                        </div>
                        <div class="col-md-5">
                            <ul class="sub_total_area right">
                                <li><label>@lang('quickadmin.order.fields.invoice_number')</label><span>#{{ $order->invoice_number }}</span></li>
                                <li><label>@lang('quickadmin.order.fields.invoice_date')</label><span>{{$order->invoice_date->format('d-M-Y')}}</span></li>
                                <li><label>@lang('quickadmin.order.fields.created_at')</label><span>{{$order->created_at->format('d-M-Y h:i A')}}</span></li>  
                            </ul>                            
                        </div>
                    </div>
                    <div class="pt-3 pb-4">
                        <div class="table-responsive">
                            <table class="table custom_table modal-table-width" id="orderProductTable">
                                <thead>
                                    <tr>
                                        <th>@lang('quickadmin.qa_sn')</th>
                                        <th>@lang('quickadmin.order.fields.product_name')</th>
                                        <th>@lang('quickadmin.order.fields.dispatch_place')</th>
                                        <th>@lang('quickadmin.order.fields.quantity')</th>
                                        <th>@lang('quickadmin.order.fields.price')</th>
                                        <th>@lang('quickadmin.order.fields.amount') (₹)</th>                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($order->orderProduct as $index => $product)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $product->product ? $product->product->full_name : 'Deleted Product' }}</td>
                                        <td>{{ config('app.product_place.' . $product->dispatch_place) }}</td>
                                        <td>{{ $product->quantity }} {{ $product->product ? $product->product->product_unit->name :''}}</td>
                                        <td>{{ $product->price }}</td>
                                        <td>{{ $product->total_price }}</td>
                                    </tr>
                                    @endforeach                                    
                                </tbody>                                                 
                            </table>
                        </div>
                    </div>  
                    <div class="row">
                        <div class="col-md-5 col-lg-5 col-xl-5 ml-auto">
                            <ul class="sub_total_area bottom">
                                <li><label>@lang('quickadmin.order.fields.sub_total_amount')</label><span id="sub_total">₹ {{ $order->sub_total ?? 0  }}</span></li>
                                <li><label>@lang('quickadmin.order.fields.labour_bhada')</label><span id="labour_bhada">₹ {{ $order->labour_bhada ?? 0  }}</span></li>
                                <li><label>@lang('quickadmin.order.fields.gadi_bhada')</label><span id="gadi_bhada">₹ {{ $order->gadi_bhada ?? 0  }}</span></li>
                                <li class="subtotle"><label>@lang('quickadmin.order.fields.grand_total')</label><span id="grand_total">₹ {{ $order->grand_total ?? 0  }}</span></li>
                            </ul>                            
                        </div>
                        <div class="col-12 col-xl-12">                            
                            @if ($order->remark)
                            <h6>
                                <label for="remark">@lang('quickadmin.order.fields.remark') : </label>
                                <span id="remark">{{ $order->remark ?? " "  }}</span>                                
                            </h6>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
