<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@lang('quickadmin.order.invoice')</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');
        body {
            /* font-family: Arial, sans-serif; */
            font-family: "Montserrat", sans-serif !important;
        }
        /* .MainBox {
            padding: 20px;
            border: 1px solid #aeb1c133;
            margin: 20px;
        } */
        .mainHeading h2 {
            text-align: center;
        }
        .sub_total_area {
            list-style: none;
            padding: 0;
        }
        .sub_total_area li {
            font-weight: 600;
            margin: 0 0px 15px;
            line-height: 16px;
            font-size: 16px;
            color: #2a2a2a;
        }
        .sub_total_area.right li {
            display: flex;
            justify-content: space-between;
        }
        .sub_total_area.right li label{
            text-align: left;
        }
        .sub_total_area li span{
            font-weight: 500;
            padding-left: 20px;
        }
        .sub_total_area li label{
            min-width: 90px;
            display: inline-block;
        }
        .table-group {
            margin-bottom: 40px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .table th, .table td {
            border: 1px solid #555;
            padding: 8px;
            text-align: left;
        }
        .top-invoice-details {
            display: flex;
            justify-content: space-between;
        }
        .footer-group .sub_total_area,
        .top-invoice-details .sub_total_area.right{
            max-width: 300px;
            width: 300px;
            margin-left: auto;
        }
        .footer-group .sub_total_area li{
            display: flex;
            justify-content: space-between;
        }
        .footer-group .sub_total_area li.subtotal{
            padding: 15px 0px;
            border-top: 1px solid #555;
            border-bottom: 1px solid #555;
            font-size: 20px;
            color: 000;
        }
        .footer-group .sub_total_area li.subtotal span{
            font-weight: 700;
        }
        .footer-group .remark{
            margin-top: 40px;
        }
        .small-text-gray {
            font-size: 10px; 
            color: #666;
        }
    </style>
</head>
<body>
    <div class="card MainBox ">
        <div class="mainHeading">
            <h2>@lang('quickadmin.order.invoice')</h2>           
            <div class="top-invoice-details">            
                <ul class="sub_total_area left">
                    <li><label>Bill To : </label><span>{{ $order->customer->name ?? '' }}</span></li>
                    <li><label>Address : </label><span>{{ $order->customer?->area?->address }}</span></li>
                    <li><label>Phone no : </label><span>{{ $order->customer->phone_number ?? '' }}</span></li>
                </ul>                            
                <ul class="sub_total_area right">
                    <li><label>@lang('quickadmin.order.fields.invoice_number') : </label><span>#{{ $order->invoice_number }}</span></li>
                    <li><label>@lang('quickadmin.order.fields.invoice_date') : </label><span>{{$order->invoice_date->format('d-M-Y')}}</span></li>
                    <li><label>@lang('quickadmin.order.fields.created_at') : </label><span>{{$order->created_at->format('d-M-Y H:i A')}}</span></li>                    
                </ul>                            
            </div>
        </div>
        <div class="table-group">
            <div class="table-responsive">
                <table class="table custom_table" id="orderProductTable">
                    <thead>
                        <tr>
                            <th>@lang('quickadmin.qa_sn')</th>
                            <th>@lang('quickadmin.order.fields.product_name')</th>
                            <th style="width: 140px;">@lang('quickadmin.order.fields.dispatch_place')</th>
                            <th>@lang('quickadmin.order.fields.quantity')</th>
                            <th>@lang('quickadmin.order.fields.price')</th>
                            <th style="width: 130px;">@lang('quickadmin.order.fields.amount') (₹)</th>                                        
                        </tr> 
                    </thead>
                    <tbody>
                        @foreach ($order->orderProduct()->get() as $index => $product)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $product->product->full_name }} </td>
                            <td>{{ ucwords($product->dispatch_place) }}</td>
                            <td>{{ $product->quantity }} {{ $product->product ? $product->product->product_unit->name :''}}</td>
                            <td>{{ $product->price }}</td>
                            <td>{{ $product->total_price }}</td>
                        </tr>    
                        @endforeach                        
                    </tbody>                                       
                </table>
            </div>
        </div> 
        <div class="footer-group">
            <ul class="sub_total_area">
                <li><label>@lang('quickadmin.order.fields.sub_total_amount') : </label> <span id="sub_total">₹ {{ $order->sub_total ?? 0  }}</span></li>
                <li><label>@lang('quickadmin.order.fields.labour_bhada') : </label> <span id="labour_bhada">₹ {{ $order->labour_bhada ?? 0  }}</span></li>
                <li><label>@lang('quickadmin.order.fields.gadi_bhada') : </label> <span id="gadi_bhada">₹ {{ $order->gadi_bhada ?? 0  }}</span></li>
                <li class="subtotal"><label>@lang('quickadmin.order.fields.grand_total') : </label> <span id="grand_total">₹ {{ $order->grand_total ?? 0  }}</span></li>
            </ul>  
            <div class="remark">
                @if ($order->remark)
                    <label for="remark">@lang('quickadmin.order.fields.remark') : </label>
                    <span id="remark">{{ $order->remark ?? " "  }}</span>    
                @endif                                
            </div>
        </div>       
        
    </div>
</body>
</html>
