@extends('layouts.print-view.print-layout')
@section('title')@lang('quickadmin.inventory.inventory_report')@endsection

@section('custom_css')

@endsection

@section('content')
    <div class="page-header">
        <header style="padding: 1px 0; max-width: 100%; margin: 0 auto;">
            <h2 style="margin: 0;color: #2a2a33;font-size: 18px;font-weight: bold; text-align:center;"><strong>@lang('quickadmin.inventory.inventory_report')</strong></h2>
        </header>
    </div>
    <main class="main" style="max-width: 100%;margin: 0 auto;padding: 40px 0;padding-top: 20px;">
       <table cellpadding="0" cellspacing="0" width="100%" style="color: #000;font-size: 15px;">
            <tbody>
                <tr>
                    <th style="padding: 8px;border: 1px solid #000;border-right: none;" align="left">@lang('quickadmin.qa_sn')</th>
                    <th style="padding: 8px;border: 1px solid #000;border-right: none;" align="center">@lang('quickadmin.inventory.fields.storage_type')</th>
                    <th style="padding: 8px;border: 1px solid #000;border-right: none;" align="center">@lang('quickadmin.inventory.fields.brand_name')</th>
                    <th style="padding: 8px;border: 1px solid #000;border-right: none;" align="center">@lang('quickadmin.inventory.fields.product_name')</th>
                    <th style="padding: 8px;border: 1px solid #000;" align="center">@lang('quickadmin.inventory.fields.stock')</th>
                </tr>
            
                @forelse ($inventories as $key => $inv)
                    @php
                        $total_sell = getSellProductByPlace($inv->product_id, $inv->place);
                        $total_left = $inv->total_buy - $total_sell;
                    @endphp
                    <tr>
                        <td style="padding: 8px;border: 1px solid #000;border-right: none;" align="left">{{ $key + 1 }}</td>
                        <td style="padding: 8px;border: 1px solid #000;border-right: none;" align="center">{{ $places[$inv->place] ?? $inv->place }}</td>
                        <td style="padding: 8px;border: 1px solid #000;border-right: none;" align="center">{{ $inv->product->brands->name ?? '' }}</td>
                        <td style="padding: 8px;border: 1px solid #000;border-right: none;" align="center">{{ $inv->product->name ?? '' }}</td>
                        <td style="padding: 8px;border: 1px solid #000;" align="center">{{ $total_left }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" style="padding: 8px;border: 1px solid #000;border-top: none;" align="center">No Record Found!</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

    </main>
@endsection
