
@extends('layouts.app')
@section('title')@lang('quickadmin.inventory.inventory_report')@endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
@endsection
@section('main-content')

<div class="card MainBox">
    <div class="mainHeading">
        <h4 class="text-capitalize">{{$product->name}}
                @if($place)
                    - {{ config('app.product_place.' . $place) }}
                @endif
        </h4>
        <div class="top_both_btn">
            <a href="#" class="btn d-none"></a> <!-- dummy btn  -->
            <button type="button"  title="Print" class="btn addRecordBtn addBtn print_btn_inventory printbtn--"><x-svg-icon icon="print" />@lang('quickadmin.qa_print')</button>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table_top-content">
            <div class="tTop-contentLeft">
                <a href="{{route('inventory_list.view')}}"><x-svg-icon icon="backarrow" /> @lang('quickadmin.back_list')</a>
            </div>
            <div class="tTop-contentRight">
                @can('estimate_date_filter_access')
                    <div class="">
                        <form id="invoice-filter-form" action="">
                            <div class="cart_filter_box">                                
                                @can('estimate_date_filter_access')
                                <div class="mx-0 datapikergroup custom-select2 floatingLabel">
                                    <div class="form-control-inner form-group">
                                        <label for="reportrange">@lang('quickadmin.inventory.fields.select_date')</label>
                                        <div id="reportrange" class="pull-right">
                                            <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>&nbsp;
                                            <span></span> <b class="caret"></b>
                                        </div>
                                    </div>
                                </div>
                                @endcan
                                <div class="form-group mb-0">
                                    <button type="submit" class="btn addRecordBtn addBtn" id="apply-filter"><i class="fa fa-paper-plane" aria-hidden="true"></i>
                                        @lang('quickadmin.qa_submit')
                                    </button>
                                    <a href="{{route('inventory_detail',['id' => $product->id, 'place' => $place])}}" class="btn addRecordBtn addBtn text-white" id="reset-filter"><i class="fa fa-refresh" aria-hidden="true"></i>
                                        @lang('quickadmin.qa_reset')
                                    </a>
                                </div>                             
                            </div>
                        </form>
                    </div>
                @endcan
            </div>
        </div>
        <div class="table-responsive fixed_Search" id="print_html">
            <style>
                @media print {
                    .custom_table{
                        width: 99% !important;
                    }
                    .custom_table thead tr:first-child th:first-child{
                        width: 180px !important;
                    }
                    .custom_table tfoot tr th{
                        color: #062142 !important;
                    }
                    .custom_table tbody td .btn{
                        color: #000 !important;
                        border: none !important;
                        font-size: 16px !important;
                    }
                }
            </style>
            <table class="table custom_table table_Footer">
                <thead>
                    <tr>
                        <th>Estimate Date</th>
                        <th>Particulars</th>
                        {{--<th>Estimate Number</th>--}}
                        <th>Buy</th>
                        <th>Sell</th>
                        <th>Balance Stock</th>
                        {{--<th>Balance In  Ware House </th>
                        <th>Balance In Shop</th>
                        <th>Balance In Cold Storage</th>--}}
                    </tr>
                    @php
                        $lastBalance = (int)$openingBalance;
                        $blaceStock = $lastBalance;
                    @endphp
                    <tr>
                        <th colspan="9" class="text-center">Opening Stock {{$lastBalance}}</th>
                    </tr>
                    </thead>
                <tbody>
                    @foreach ($alldata as $key => $data)
                    @php 
                        if($data->type == 'Buy'){
                            $blaceStock += (int)$data->quantity;    
                        }
                        if($data->type == 'Sell' || $data->type == 'Shift'){
                            $blaceStock -= (int)$data->quantity;
                        }
                    @endphp 
                
                    <tr> 
                        <td>{{ $data->transaction_date ? \Carbon\Carbon::parse($data->transaction_date)->format('d-m-Y') : '' }}</td> 
                            <td>
                            @if($data->type == 'Sell')
                                <button class="btn btn-icon btn-info view-invoice-btn p-1 bg-info text-white" data-href="{{route('orders.show', $data->uuid)}}">@lang('quickadmin.inventory.fields.invoice')</button>
                                <span class="d-flex align-items-center mt-2">
                                    {{ $data->invoice_number}}
                                </span>
                            @elseif($data->type == 'Shift')
                                <button class="btn btn-icon btn-info view-inventory-btn shift-sell p-1 bg-info text-white" data-href="{{route('shifting-good.show', $data->shift->id)}}">@lang('quickadmin.inventory.fields.shift_sell')</button>
                                <span class="d-flex align-items-center mt-2">
                                    {{ config('app.product_place.' . $data->place) }}
                                    <svg xmlns="http://www.w3.org/2000/svg" 
                                        width="16" height="16" viewBox="0 0 24 24" 
                                        fill="none" stroke="currentColor" stroke-width="2" 
                                        stroke-linecap="round" stroke-linejoin="round" 
                                        class="mx-1 feather feather-chevron-right">
                                        <polyline points="9 18 15 12 9 6"></polyline>
                                    </svg>
                                    {{ config('app.product_place.' . $data->shifted_to) }}
                                </span>
                            @else
                            @if($data->shift) 
                                    <button class="btn btn-icon btn-info view-inventory-btn p-1 bg-info text-white" data-href="{{route('shifting-good.show', $data->shift->id)}}">@lang('quickadmin.inventory.fields.shift_buy')</button>
                                    <span class="d-flex align-items-center mt-2">
                                        {{ config('app.product_place.' . $data->shift->from) }}
                                        <svg xmlns="http://www.w3.org/2000/svg" 
                                            width="16" height="16" viewBox="0 0 24 24" 
                                            fill="none" stroke="currentColor" stroke-width="2" 
                                            stroke-linecap="round" stroke-linejoin="round" 
                                            class="mx-1 feather feather-chevron-right">
                                            <polyline points="9 18 15 12 9 6"></polyline>
                                        </svg>
                                        {{ config('app.product_place.' . $data->place) }}
                                    </span>
                                @else
                                    <button class="btn btn-icon btn-info view-inventory-btn p-1 bg-info text-white" data-href="{{route('inventory.show', $data->uuid)}}">
                                        @lang('quickadmin.inventory.fields.add_inventory')
                                    </button>
                                @endif
                            @endif
                        </td>
                            <td>{{ ($data->type == 'Buy')?(int)$data->quantity??'':''}}</td>
                            <td>{{ ($data->type == 'Sell' || $data->type == 'Shift')?(int)$data->quantity??'':''}}</td>
                            <td>{{ (int)$blaceStock}}</td>                                         
                    </tr>                               
                    @endforeach
                </tbody>
                <tfoot>
                    <tr> 
                        <th colspan="5" class="text-center">Closing Stock {{$blaceStock}}</th>
                    </tr>
                </tfoot>        
            </table>
        </div>
    </div>
</div>
<div class="popup_render_div"></div>

@endsection


@section('customJS')
    <script src="{{ asset('admintheme/assets/bundles/datatables/datatables.min.js') }}"></script>
    <script src="{{ asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admintheme/assets/bundles/jquery-ui/jquery-ui.min.js') }}"></script>
    <!-- Page Specific JS File -->
    <script src="{{ asset('admintheme/assets/js/page/datatables.js') }}"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
   
    <script src="https://cdnjs.cloudflare.com/ajax/libs/printThis/1.15.0/printThis.min.js" integrity="sha512-d5Jr3NflEZmFDdFHZtxeJtBzk0eB+kkRXWFQqEc1EKmolXjHm2IKCA7kTvXBNjIYzjXfD5XzIjaaErpkZHCkBg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>                                  

    <script type="text/javascript">
        $(function() {
            var date = '{{ config("app.start_date")}}';
           // var start = moment(date, 'YYYY-MM-DD'); /*.moment().startOf('month')*/         
            var end = moment();
            var start = moment("{{$from_date}}", 'YYYY-MM-DD');
            var end = moment("{{$to_date}}", 'YYYY-MM-DD');

            function cb(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }
            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);
            cb(start, end);
        });
        $(document).ready(function(){
            $(document).on('submit','#invoice-filter-form',function(e){
                e.preventDefault(); 
                var action = $(this).attr('action');
                var picker = $('#reportrange').data('daterangepicker'); 
                var start_date = "";          
                var end_date = "";          
                if (picker && picker.startDate && picker.endDate) {
                    var start_date = picker.startDate.format('YYYY-MM-DD');
                    var end_date = picker.endDate.format('YYYY-MM-DD');
                } 
                var query = '?start_date=' + start_date + '&end_date=' + end_date;
                window.location.href = action + query;
            });
            $(document).on('click','.print_btn_inventory',function(){
                let productName ="{{$product->name}}";
                 $('#print_html').printThis({
                    header: `<h4 style='text-align:center;text-transform: capitalize;'>${productName}</h4>`, // Use the product name in the header
                 });
            });

                
            $(document).on("click", ".view-inventory-btn", function (e) {
                e.preventDefault();
                var hrefUrl = $(this).attr('data-href');
                $.ajax({
                    type: 'get',
                    url: hrefUrl,
                    dataType: 'json',
                    success: function (response) {
                        if(response.success) {
                            $('.popup_render_div').html(response.htmlView);
                            $('#inventoryViewModal').modal('show');                  
                        }
                    }
                });
            });

            $(document).on("click", ".view-invoice-btn", function (e) {
                e.preventDefault();
                var hrefUrl = $(this).attr('data-href');
                $.ajax({
                    type: 'get',
                    url: hrefUrl,
                    dataType: 'json',
                    success: function (response) {
                        if(response.success) {
                            $('.popup_render_div').html(response.htmlView);
                            $('#viewModal').modal('show');
                            $('#order-detail-print').printPage(); 
                        }
                    }
                });
            });

        })
    </script>


@endsection
