@extends('layouts.app')
@section('title')@lang('quickadmin.cash-management.title') @endsection
@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}">
<link rel="stylesheet" href="{{ asset('admintheme/assets/css/printView-datatable.css')}}">
@endsection
@section('main-content')
<div class="card MainBox">
    <div class="mainHeading">
        <h4>@lang('quickadmin.cash-management.title')</h4>   
       <div>
            @can('cash_management_create')
            <a href="{{ route('cash-management.create') }}" class="btn addRecordBtn addBtn add_brand" title="@lang('quickadmin.new') @lang('quickadmin.cash-management.fields.new_cash_expense')" ><i class="fas fa-plus"></i>
                <span>@lang('quickadmin.new')</span>
                @lang('quickadmin.cash-management.fields.new_cash_expense')
            </a>
            @endcan   
       </div>   
    </div>
    <div class="card-body p-0">
      <div class="table-responsive fixed_Search cash-management-table">
        {{$dataTable->table(['class' => 'table dt-responsive estimates_transactions_table cash-reciept-trans', 'style' => 'width:100%;'])}}
      </div>
    </div>
  </div>
</div>
<div class="popup_render_div"></div>

@endsection

@section('customJS')
{!! $dataTable->scripts() !!}
<script src="{{ asset('admintheme/assets/bundles/datatables/datatables.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('admintheme/assets/js/page/datatables.js') }}"></script>

<script type="text/javascript">
var order_selectedIds = [];
$(document).ready(function() {
    var DataaTable = $('#cash-management-table').DataTable();

    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });

    $(document).on('draw.dt','#payment_transaction-table', function (e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, 'fast');
    });

    $(document).on("click", ".view_cashreceipt", function (e) {
        e.preventDefault();
        var hrefUrl = $(this).attr('data-href');
        $.ajax({
            type: 'get',
            url: hrefUrl,
            dataType: 'json',
            beforeSend: function () {
                showLoader();
            },
            success: function (response) {
                if(response.success) {
                    $('.popup_render_div').html(response.htmlView);
                    $('#viewModal').modal('show');
                }
            },
            complete: function () {
                hideLoader();
            },
        });
    });

    
    $(document).on('click', '.delete_transaction', function(e) {
        e.preventDefault();
        var hrefUrl = $(this).attr('data-href');
        swal({
            title: "{{ trans('messages.deletetitle') }}",
            text: "{{ trans('messages.areYouSure') }}",
            icon: 'warning',
            buttons: {
            confirm: "{{ trans('quickadmin.qa_delete') }}",
            cancel: "{{ trans('quickadmin.qa_cancel') }}",
            },
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                url: hrefUrl,
                type: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (response) {
                    var alertType = response['alert-type'];
                        var message = response['message'];
                        var title = response['title'];
                        showToaster(title,alertType,message);
                        DataaTable.ajax.reload();
                },
                error: function (xhr) {
                    swal("{{ trans('quickadmin.cash-management.title') }}", 'Something went wrong', 'error');
                }
                });
            }
        });
    });

});

</script>
@endsection
