
@extends('layouts.app')
@section('title')@lang('quickadmin.cash-balance.title') @endsection

@section('customCss')
<meta name="csrf-token" content="{{ csrf_token() }}" >
<!-- Bootstrap Datepicker CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css" rel="stylesheet">
<style>

</style>
@endsection
@section('main-content')
<div class="card MainBox">
    <div class="mainHeading">
        <h4 class="text-nopwrap">@lang('quickadmin.cash-balance.view_detail') ( {{ $formattedMonthYear }} )</h4>
    </div>
    <div class="card-body p-0">
        <div class="table_top-content">
            <div class="tTop-contentLeft">
                <a href="{{ route('cash-ledger.index') }}"> <x-svg-icon icon="backarrow" /> Back to List </a>
            </div>
        </div>

        <div class="table-responsive fixed_Search">
            <table class="table custom_table table_Footer ledger-table">
                <thead>
                    <tr>
                        {{-- <th>@lang('quickadmin.cash-balance.fields.created_date')</th> --}}
                        <th>@lang('quickadmin.cash-balance.fields.particulars')</th>
                        <th>@lang('quickadmin.cash-balance.fields.debit')</th>
                        <th>@lang('quickadmin.cash-balance.fields.credit')</th>
                        <th>@lang('quickadmin.cash-balance.fields.balance')</th>
                        <th>@lang('quickadmin.qa_action')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <th colspan="1" class="text-right">@lang('quickadmin.cash-balance.fields.opening_balance') </th>
                        <th></th>
                        <th colspan="4" class="text-left">₹ {{number_format($openingBalance, 2, '.', ',')}}</th>
                    </tr>
                    @php
                        $totalDebit = 0;
                        $totalCredit = 0;
                        $lastBalance = 0;
                    @endphp
                    
                    @foreach ($alldata as $data)
                        @php
                            $debitAmount = $data->transaction_type  == 'debit' ? (float) $data->recordable->amount : 0;
                            $creditAmount = $data->transaction_type == 'credit' ? (float) $data->recordable->amount : 0;
                            $balance = $lastBalance + $debitAmount - $creditAmount;
                        @endphp
                        <tr>
                            {{-- <td>{{ $data->created_date ? \Carbon\Carbon::createFromFormat('Y-m-d', $data->created_date)->format('d/m/Y') : '' }}</td> --}}
                            <td>
                                {{ $data->particulars }}
                            </td>
                            <td>{!! $data->transaction_type=='debit' ? '₹ ' . $data->recordable->amount : '' !!}</td>
                            <td>{!! $data->transaction_type=='credit' ? '₹ ' . $data->recordable->amount : "" !!}</td>
                            <!-- <td>{!! $balance ? '₹ ' . number_format(abs($balance), 2, '.', ',') : 0 !!}{{ $balance<=1 ? ' Cr' : ' Dr'}}</td> -->
                            <td class="{{ $balance <= 1 ? 'cr-case' : 'dr-case' }}">
                                {!! $balance ? '₹ ' . number_format(abs($balance), 2, '.', ',') : 0 !!}
                                {{ $balance <= 1 ? ' Cr' : ' Dr' }}
                            </td>
                            <td>
                                <button data-href="{{ route('cash-ledger.show', $data->id) }}"  class="btn btn-icon btn-info view_cashreceipt" title="{{ trans('quickadmin.qa_view')}}" ><x-svg-icon icon="view" /></button>
                            </td>
                            
                        </tr>
                        @php
                            if ($data->transaction_type == 'debit') {
                                $totalDebit += $data->recordable->amount;
                            } elseif ($data->transaction_type == 'credit') {
                                $totalCredit += $data->recordable->amount;
                            }
                            $lastBalance = $balance;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="1" class="text-right">@lang('quickadmin.cash-balance.fields.current_balance')</th>
                        <th><span>₹{{ number_format($totalDebit, 2, '.', ',') }}</span></th>
                        <th colspan="3">₹{{ number_format($totalCredit, 2, '.', ',') }}</th>
                    </tr>
                    @php
                       $grandTotal = number_format(abs($totalDebit + $openingBalance - $totalCredit), 2, '.', ',');
                    @endphp
                    <tr>
                        <th colspan="1" class="text-right">@lang('quickadmin.cash-balance.fields.closing_balance')</th>
                        <th colspan="4" class="text-left"><span>₹{{ $grandTotal }}</span></th>
                    </tr>
                </tfoot>  
            </table>
        </div>
    </div>
</div>
<div class="popup_render_div"></div>

@endsection

@section('customJS')

<script>
    $(document).ready(function () {

        $(document).on("click", ".view_cashreceipt", function (e) {
            e.preventDefault();
            var hrefUrl = $(this).attr('data-href');
            $.ajax({
                type: 'get',
                url: hrefUrl,
                dataType: 'json',
                success: function (response) {
                    if(response.success) {
                        $('.popup_render_div').html(response.htmlView);
                        $('#viewModal').modal('show');
                    }
                }
            });
        });
    });
</script>
@endsection
