
<tbody>
{{--<tr>
        <th colspan="1" class="text-right">@lang('quickadmin.cash-balance.fields.opening_balance') </th>
        <th></th>
        <th colspan="4" class="text-left">₹ {{number_format($openingBalance, 2, '.', ',')}}</th>
    </tr>--}}
    @php
        $totalDebit = 0;
        $totalCredit = 0;
        $lastBalance = 0;
    @endphp
    
    @forelse ($alldata as $data)
        @php
            $debitAmount = $data['total_debit'] ?? 0;
            $creditAmount =  $data['total_credit'] ?? 0;
            $balance = $lastBalance + $debitAmount - $creditAmount;
            $formattedMonth = \Carbon\Carbon::createFromFormat('Y-m', $data['month']);
            $year = $formattedMonth->year;
            $month = $formattedMonth->month;
        @endphp
        <tr>
            <td>{{ $formattedMonth->format('F Y') }}</td>
            <td>{!! $debitAmount ? '₹ ' . number_format(abs($debitAmount), 2, '.', ',') : '0.00' !!}</td>
            <td>{!! $creditAmount ? '₹ ' . number_format(abs($creditAmount), 2, '.', ',') : '0.00' !!}</td>
            <!-- <td>{!! $balance ? '₹ ' . number_format(abs($balance), 2, '.', ',') : 0 !!}{{ $balance<=1 ? ' Cr' : ' Dr'}}</td> -->
             <td class="{{ $balance <= 1 ? 'cr-case' : 'dr-case' }}">
                    {!! $balance ? '₹ ' . number_format(abs($balance), 2, '.', ',') : '0.00' !!}
                    {{ $balance <= 1 ? ' Cr' : ' Dr' }}
                </td>
            <td>
                <a href="{{ route('cash-ledger.view',['year' => $year, 'month' => $month]) }}"  class="btn btn-icon btn-info" title="{{ trans('quickadmin.qa_view')}}" ><x-svg-icon icon="view" /></a>
            </td>            
        </tr>
        @php
            $totalDebit += $debitAmount;
            $totalCredit += $creditAmount;
            $lastBalance = $balance;
        @endphp
    @empty
        <tr>
            <td colspan="5" class="text-center">No Record found</td>
        </tr>
    @endforelse
</tbody>

<tfoot>
    <tr>
        <th colspan="1" class="text-right">@lang('quickadmin.cash-balance.fields.current_balance')</th>
        <th><span>₹ {{ number_format($totalDebit, 2, '.', ',') }}</span></th>
        <th colspan="3">₹{{ number_format($totalCredit, 2, '.', ',') }}</th>
    </tr>
    @php
       $grandTotal = $totalDebit + $openingBalance - $totalCredit;
    @endphp
    <tr>
        <th colspan="1" class="text-right">@lang('quickadmin.cash-balance.fields.closing_balance')</th>
        <th colspan="4" class="text-left"><span>₹{{number_format(abs($grandTotal), 2, '.', ',') }} {{ $grandTotal <= 1 ? 'Cr' : 'Dr' }}</span></th>
    </tr>
</tfoot>   