<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cash_receipt_amounts', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('payment_transaction_id');

            $table->enum('payment_way', ['order_create', 'order_return', 'by_cash','by_phonepay', 'by_check', 'by_account'])->default('order_create');
            $table->decimal('amount', 15, 2);
            $table->timestamps();

            $table->foreign('payment_transaction_id')->references('id')->on('payment_transactions')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_receipt_amounts');
    }
};


