<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_products', function (Blueprint $table) {
            $table->enum('dispatch_place', ['warehouse', 'shop', 'cold_storage'])
                ->default('warehouse')
                ->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_products', function (Blueprint $table) {

            $table->enum('dispatch_place', ['warehouse', 'shop'])
                  ->default('warehouse')
                  ->change();
        });
    }
};
