<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shifting_goods', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id');
            $table->enum('from', ['warehouse','shop','cold_storage'])->default('warehouse');
            $table->enum('to', ['warehouse','shop','cold_storage'])->default('warehouse');
            $table->date('entry_date')->nullable();
            $table->decimal('quantity', 15, 3);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shifting_goods');
    }
};
