<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cash_management', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->unsignedBigInteger('user_id');  
            $table->string('voucher_number')->default(null)->nullable();          
            $table->enum('payment_way', array('by_cash', 'by_check', 'by_account'))->default('by_cash');            
            $table->string('remark')->nullable();
            $table->decimal('amount', 15, 2);
            $table->date('entry_date')->nullable();             
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();            
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('deleted_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_management');
    }
};
