<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->unsignedBigInteger('customer_id')->index();
            $table->string('invoice_number')->nullable();
            $table->date('invoice_date')->nullable();
            $table->enum('order_type', ['create', 'return'])->default('create');
            $table->decimal('labour_bhada', 10, 2)->default(0);
            $table->decimal('gadi_bhada', 10, 2)->default(0);
            $table->tinyInteger('is_round_off')->default(0)->comment('1=> Yes, 0=>No');
            $table->decimal('round_off_amount', 15, 2)->nullable();
            $table->decimal('sub_total', 15, 2);
            $table->decimal('grand_total', 15, 2);
            $table->text('remark')->nullable();
            $table->tinyInteger('is_modified')->default(0)->comment('1=> modified, 0=>not_modified');
            $table->unsignedBigInteger('created_by')->index()->nullable();
            $table->unsignedBigInteger('updated_by')->index()->nullable();
            $table->unsignedBigInteger('deleted_by')->index()->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign keys
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('deleted_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
