<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\Product;
use App\Models\OrderProduct;
use App\Models\Inventory;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class InventoryValidationRule implements Rule
{
    protected $request;
    protected $validationType;
    protected $additionalParams;
    public function __construct($request, $validationType,$additionalParams = [])
    {
        $this->request = $request;
        $this->validationType = $validationType;
        $this->additionalParams = $additionalParams;
    }


    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        switch ($this->validationType) {
            case 'check_quantity':
                return $this->checkEditQuantityExists($value,$this->additionalParams['product_id'],$this->additionalParams['id'], $this->additionalParams['place']);
            case 'product_exists':
                return $this->checkProductExists($value);
            default:
                return true;
        }
    }

    
    protected function checkProductExists($value)
    {
        return Product::where('id', $value)->exists();
    }
    protected function checkEditQuantityExists($value,$product_id,$id,$place)
    {   
        // new inventory or existinog 
         $IsSameProduct = Inventory::where('product_id',$product_id)->where('place',$place)->where('uuid',$id)->first();
         if($IsSameProduct){
            $totalQuantity =  Inventory::where('product_id',$product_id)->where('place',$place)->where('uuid','<>',$id)->sum('quantity');
            $totalQuantity = $totalQuantity+$value;
            $dispach_order = OrderProduct::where('product_id', $product_id)->where('dispatch_place',$place)->sum('quantity');
            if($totalQuantity < $dispach_order ){
                return false;
            }
         }else{
            //update new inventory then old Product quantity check
            $oldProductData = Inventory::where('uuid',$id)->first();
            if($oldProductData){
                $IsSameProduct = Inventory::where('product_id',$oldProductData->product_id)->where('place',$oldProductData->place)->where('uuid','<>',$id)->sum('quantity');
                $dispach_order = OrderProduct::where('product_id', $oldProductData->product_id)->where('dispatch_place',$oldProductData->place)->sum('quantity');
                if($IsSameProduct < $dispach_order ){
                    return false;
                }                
            }
        }
        return true;
        // new product or existinog      
    }
  

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {   
        switch ($this->validationType) {
            case 'check_quantity':
                return 'Quantity is already delivered';
            case 'product_exists':
                return 'product id does not exits';
            default:
                return 'Validation error.';
        }
    }

}
