<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderProduct extends Model
{
    use HasFactory , SoftDeletes , UuidTrait;

    public $timestamps = true;

    protected $fillable = [
        'uuid',
        'order_id',
        'product_id',
        'quantity',
        'price',       
        'total_price',
        'dispatch_place',        
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function(OrderProduct $model) {
            $model->created_by = auth()->user()->id;
        });

        static::deleting(function(OrderProduct $model) {
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });

        static::updating(function(OrderProduct $model) {
            $model->updated_by = auth()->user()->id;
        });
    }

    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id')->withTrashed();
    }

    public function deletedBy()
    {
        return $this->belongsTo(User::class, 'deleted_by');
    }
}
