<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model
{
    use HasFactory,SoftDeletes,UuidTrait;

    protected $table = 'orders';
    public $timestamps = true; 

    protected $casts = [
        'invoice_date' => 'date',
        'due_date' => 'date',
    ];

    protected $fillable = [
        'uuid',
        'customer_id',
        'invoice_number',
        'invoice_date',        
        'order_type',        
        'labour_bhada',
        'gadi_bhada',
        'is_round_off',
        'round_off_amount',
        'sub_total',        
        'grand_total',
        'remark',
        'is_modified',
        'created_by',
        'updated_by',
        'deleted_by'
    ];

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    protected static function boot()
    {
        parent::boot();
        static::creating(function(Order $model) {
            $model->created_by = auth()->user()->id;
        });

        static::deleting(function(Order $model) {
            foreach ($model->orderProduct as $orderProduct) {
                $orderProduct->deleted_by = auth()->user()->id; // Set deleted_by
                $orderProduct->save();
                $orderProduct->delete(); // Soft delete the order product
            }
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });
     
        static::updating(function(Order $model) {
            $model->updated_by = auth()->user()->id;
           // $model->is_modified = 1;
        });
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function orderProduct()
    {
        return $this->hasMany(OrderProduct::class, 'order_id');
    }

    public function orderPayTransaction()
    {
        return $this->hasMany(PaymentTransaction::class, 'order_id');
    }

    // public function history()
    // {
    //     return $this->hasMany(OrderEditHistory::class);
    // }

}
