<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Inventory extends Model
{
    use HasFactory,SoftDeletes,UuidTrait;

    public $table = 'inventories';
    public $timestamps = true;    

    protected $casts = [
        'entry_date' => 'date',
    ];

    protected $fillable = [
        'uuid',
        'product_id',
        'place',      
        'entry_date',
        'quantity',
        'remark',
        'is_active',
        'type',
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
        'shift_id'
    ];   
    

    protected static function boot()
    {
        parent::boot();
        static::creating(function(Inventory $model) {
            $model->created_by = auth()->user()->id;
        });

        static::deleting(function(Inventory $model) {
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });

        static::updating(function(Inventory $model) {
            $model->updated_by = auth()->user()->id;
        });
    }

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    public function product(){
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function shift()
    {
        return $this->belongsTo(ShiftingGood::class, 'shift_id', 'id');
    }
    
    public function createdBy(){
        return $this->belongsTo(User::class, 'created_by');
    }

    public function deletedBy(){
        return $this->belongsTo(User::class, 'deleted_by');
    }

    
}
