<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory,SoftDeletes,UuidTrait;

    protected $table = 'customers';
    public $timestamps = true; 

    protected $fillable = [
        'name',
        'uuid',
        'phone_number',
        'alternate_phone_number',
        'remark',
        'area_id',
        'is_type',
        'credit_limit',
        'customer_type',
        'is_active',
        'created_by',
        'updated_by',
        'deleted_at',
    ];

    protected $appends = [
        'full_name',
        'debit_balance',
        'credit_balance',
        'order_count',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function(Customer $model) {
            $model->created_by = auth()->user() ? auth()->user()->id : config('constant.roles.super_admin');
        });

        static::deleting(function(Customer $model) {
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });

        static::updating(function(Customer $model) {
            $model->updated_by = auth()->user()->id;
        });
    }


    public function area(){
        return $this->belongsTo(Area::class, 'area_id');
    }

    public function transaction(){
        return $this->hasMany(PaymentTransaction::class, 'customer_id')->orderBy('entry_date','asc');
    }

    public function getFullNameAttribute()
    {
        return $this->name . ' - ' .$this->area->address . ' - ' .$this->phone_number;
    }



    public function getDebitBalanceAttribute()
    {
        return $this->transaction()
                    ->where('payment_type', 'debit')
                    // ->whereIn('payment_way',['by_cash','by_check','by_account'])
                    ->sum('amount');
    }

    public function getCreditBalanceAttribute()
    {
        return $this->transaction()
                    ->where('payment_type', 'credit')
                    // ->whereIn('payment_way',['order_create'])
                    ->sum('amount');
    }

    public function getOrderCountAttribute()
    {
        return $this->transaction()->count();
    }


}
