<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CashReceiptAmount extends Model
{
    use HasFactory;

    protected $table = 'cash_receipt_amounts';

    protected $fillable = [
        'payment_transaction_id',
        'amount',
        'payment_way',
    ];

    /**
     * Relationship to PaymentTransaction
     */
    public function transaction()
    {
        return $this->belongsTo(PaymentTransaction::class, 'payment_transaction_id');
    }
}
