<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class Brand extends Model
{
    use HasFactory, SoftDeletes , UuidTrait;

    protected $table = 'brands';
    public $timestamps = true; 
    protected $fillable = [
        'uuid',
        'name',
        'is_active',
        'created_by',
        'updated_by',
        'deleted_at',
    ];

    protected $appends = [
        'product_count',
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function(Brand $model) {
            $model->created_by = auth()->user()->id;
        });

        /*
        static::deleting(function(Brand $model) {
            $model->deleted_by = auth()->user()->id;
            $model->save();
        });
        */

        static::updating(function(Brand $model) {
            $model->updated_by = auth()->user()->id;
        });
    }

    
    public function products(){
        return $this->hasMany(Product::class, 'brand_id');
    }

    public function getProductCountAttribute()
    {
        return $this->products()->count();
    }
}
