<?php

namespace App\Http\Requests\Order;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        abort_if((Gate::denies('estimate_edit')), Response::HTTP_FORBIDDEN, '403 Forbidden');
        return true;
    }


    public function rules()
    {
        return [
            'customer_id'       => 'required|integer|exists:customers,id',
            'labour_bhada'      => 'nullable|numeric',
            'gadi_bhada'        => 'nullable|numeric',
            /*'is_round_off'      => 'required|boolean|in:1,0',
            'round_off_amount'  => 'nullable|numeric',*/
            'sub_total'         => 'required|numeric',
            'grand_total'       => 'required|numeric',
            'invoice_date'      => 'required|date',
            'remark'            => 'nullable|string|max:255',
            'products'          => 'required|array',
            'products.*.product_id'         => 'required|exists:products,id',
            'products.*.quantity'           => 'required|integer|min:1',
            'products.*.price'              => 'required|numeric',
            'products.*.total_price'        => 'required|numeric',
            'products.*.dispatch_place'     => 'required|string|in:warehouse,shop,cold_storage',
        ];
    }

    public function messages()
    {
        return [
            'customer_id.required' => 'The Customer is required.',
        ];
    }

    public function attributes()
    {
        return [ 
            'product_id' => 'Product',
            'customer_id' => 'Customer',
        ];
    }
}
