<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Rules\IsActive;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ResetPasswordController extends Controller
{
    //
    public function showform(Request $request, $token,$email){

        return view('auth.reset-password')->with(['token' => $token, 'email' => $request->email]);
    }

    public function resetpass(Request $request)
    {  
        $request->merge(['email' => decrypt($request->email)]);     
        $validated = $request->validate([
            'token' => 'required|string',
            'email' => 'required|email', new IsActive,
            'password' => 'required|string|min:8|confirmed',
            'password_confirmation' => 'required|string|min:8|same:password',

        ], getCommonValidationRuleMsgs());  
        
        $passwordResetEntry = DB::table('password_reset_tokens')
        ->where('email', $request->email)
        ->where('token', $request->token)
        ->first();

        if(!$passwordResetEntry) {
            return response()->json([
                'success' => false,
                'message' => 'This request token is Invalid!',
                'alert-type'=> trans('quickadmin.alert-type.error'),
                'title'     => 'Invalid Token !',                       
            ], 400);
        }

        $updatePassword = DB::table('password_reset_tokens')->where(['email' => $request->email,'token' => $request->token])->first();
        if(!$updatePassword)
        {
            return response()->json(['success' => false,
            'message' => trans('passwords.token'),
            'alert-type'=> trans('quickadmin.alert-type.error')], 500);
        }else{            
            $user = User::where('email', $request->email)
            ->update(['password' => Hash::make($request->password)]);
            DB::table('password_reset_tokens')->where(['email'=> $request->email])->delete();

            return response()->json([
                'success' => true,
                'message' => trans('passwords.reset'),
                'alert-type'=> trans('quickadmin.alert-type.success'),   
                'redirectUrl' => route('login')                 
            ], 200); 
        }
    }
}
