<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\BrandDataTable;
use App\Http\Controllers\Controller;
use App\Models\Brand;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class BrandController extends Controller
{
    public function index(BrandDataTable $dataTable)
    {
        abort_if(Gate::denies('brand_access'), Response::HTTP_FORBIDDEN, '403 Forbidden'); 
        return $dataTable->render('admin.brand.index');
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {  
        abort_if(Gate::denies('brand_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $validator = Validator::make($request->all(), [
            'name' => [
                'required',
                Rule::unique('brands', 'name')->whereNull('deleted_at'),
            ]]); 
        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->toArray()
            ]);
        }
        $brand_data = Brand::create(['name' => $request->name,'created_by'=> Auth::id()]); 
        addToLog($request,'Brand','Create', $brand_data);
        $brand_list = Brand::all();
        return response()->json(['success' => 'Brand Created Successfully.', 'brandData' => $brand_data, 'brandList' => $brand_data, 'brandList' => $brand_list]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort_if(Gate::denies('brand_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $id =  decrypt($id);
        $validator = Validator::make($request->all(), [
            'name' => [
                'required',
                Rule::unique('brands', 'name')->ignore($id)->whereNull('deleted_at'),
            ]]);  
        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->toArray()
            ]);
        }
        $unitData =  Brand::find($id);
        $oldvalue = $unitData->getOriginal();         
        $unitData->name = $request->name;
        $unitData->updated_by = Auth::id();
        $unitData->save();       
        $newValue = $unitData->refresh();
        addToLog($request,'Brand','Edit', $newValue ,$oldvalue);        
        return response()->json(['success' => 'Brand Updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request, string $id)
    {
        abort_if(Gate::denies('brand_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $record = Brand::find(decrypt($id));
        $oldvalue = $record->getOriginal(); 
        $record->updated_by = Auth::id();
        $record->save();
        $newValue = $record->refresh();
        addToLog($request,'Brand','Delete', $newValue ,$oldvalue);
        $record->delete();
        return response()->json(['success' => 'Brand Deleted successfully.']);
    }
}
