<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\AreaDataTable;
use App\Http\Controllers\Controller;
use App\Models\Area;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class AreaController extends Controller
{
    public function index(AreaDataTable $dataTable)
    {
        abort_if(Gate::denies('area_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        return $dataTable->render('admin.area.index');
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort_if(Gate::denies('area_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $validator = Validator::make($request->all(), [
        'address' => [
            'required',
            Rule::unique('areas', 'address')->whereNull('deleted_at'),
        ]],[
            'address.required' => 'The name field is required.',
            'address.unique' => 'The name has already been taken.',
        ]);         
        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->toArray()
            ]);
        }
        $areaData = Area::create(['address' => $request->address]); 
        addToLog($request,'Area','Create', $areaData); 
        return response()->json(['success' => 'Area Created Successfully.', 'unitData' => $areaData]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort_if(Gate::denies('area_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $id =  decrypt($id); 
        $validator = Validator::make($request->all(), [
            'address' => [
                'required',
                Rule::unique('areas', 'address')->ignore($id)->whereNull('deleted_at'),
            ]],[
                'address.required' => 'The name field is required.',
                'address.unique' => 'The name has already been taken.',
            ]);  
        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->toArray()
            ]);
        }
       $areaData =  Area::find($id);
       $oldvalue = $areaData->getOriginal();         
       $areaData->address = $request->address;
       $areaData->updated_by = Auth::id();
       $areaData->save();       
       $newValue = $areaData->refresh();
       addToLog($request,'Area','Edit', $newValue ,$oldvalue);
        return response()->json(['success' => 'Area Updated successfully.']);
    }
    
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request,string $id)
    {
        abort_if(Gate::denies('area_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');
        $record = Area::find(decrypt($id));
        $oldvalue = $record->getOriginal(); 
        $record->updated_by = Auth::id();
        $record->save();
        $newValue = $record->refresh();
        addToLog($request,'Area','Delete', $newValue ,$oldvalue);
        $record->delete();
        return response()->json(['success' => 'Area Deleted successfully.']);
    }
}
