<?php
namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use App\Models\Product;

class ProductExport implements FromCollection , WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $product_id;

    public function __construct($product_id)
    {
        $this->product_id = $product_id;
    }

    public function collection()
    {
        try{
            $query = Product::query();

            if ($this->product_id !== null) {
                $query->where('id', $this->product_id);
            }

            // $query->select(['products.*','groups.name as group_name','sub_group.name as sub_group_name','product_units.name as product_unit_name']);
            // $query->leftJoin('groups', 'groups.id', '=', 'products.group_id');
            // $query->leftJoin('groups as sub_group', 'sub_group.id', '=', 'products.sub_group_id');
            // $query->leftJoin('product_units', 'product_units.id', '=', 'products.unit_type')->orderBy('products.id','DESC');
            // $groups = $query->get();
            
            $groups = $query->select(['products.*'])->with('brands')->with('product_unit')->orderBy('products.id','DESC')->get();

            return $groups->map(function ($group, $key) {
                // $html = "";
                // $calculation = config('constant.calculationType');
                // // $html .= $calculation[$group->calculation_type];
                // if (isset($calculation[$group->calculation_type])) {
                //     $html .= $calculation[$group->calculation_type];
                // } else {
                //     $html .= "Unknown"; // Or any default value you want to set
                // }
                  return [
                    'Sn.' => $key + 1,
                    'Name' => $group->name ?? "",
                    'Brand' =>$group->brands->name ?? "",
                    'Unit Type' => $group->product_unit->name ?? "",
                    'Calculation' => $group->calculation ?? "",                    
                ];
            });
        }catch(\Exception $e){
            dd($e->getMessage(),$e->getLine());
        }


    }

    public function headings(): array
    {
        return ["Sn.", "Name" , "Brand","Unit Type" , "Calculation"];
    }
}
